<?php
/**
* Layout options
*
* @package Theme Palace
* @subpackage Business_Park_Pro
* @since Business Park Pro 2.0.0
*/

// Add copyright section
$wp_customize->add_section( 'business_park_layout', array(
	'title'               => esc_html__( 'Layout','business-park-pro' ),
	'description'         => esc_html__( 'Layout section options.', 'business-park-pro' ),
	'panel'               => 'business_park_theme_options_panel'
) );

// Archive content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[archive_content_type]', array(
	'sanitize_callback'   => 'business_park_sanitize_select',
	'default'             => $options['archive_content_type']
) );

$wp_customize->add_control( 'business_park_theme_options[archive_content_type]', array(
	'label'               => esc_html__( 'Archive Content Type', 'business-park-pro' ),
	'section'             => 'business_park_layout',
	'type'                => 'select',
	'choices'				 => business_park_archive_content(),
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'business_park_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'business_park_sanitize_select',
	'default'             => $options['sidebar_position']
) );

$wp_customize->add_control( 'business_park_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Sidebar Position', 'business-park-pro' ),
	'section'             => 'business_park_layout',
	'type'                => 'select',
	'choices'				 => business_park_sidebar_position(),
) );

// Site layout setting and control.
$wp_customize->add_setting( 'business_park_theme_options[site_layout]', array(
	'sanitize_callback'   => 'business_park_sanitize_select',
	'default'             => $options['site_layout']
) );

$wp_customize->add_control( 'business_park_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'business-park-pro' ),
	'section'             => 'business_park_layout',
	'type'                => 'select',
	'choices'				 => business_park_site_layout(),
) );

// Site animation layout setting and control.
$wp_customize->add_setting( 'business_park_theme_options[site_animation]', array(
	'sanitize_callback'   => 'business_park_sanitize_checkbox',
	'default'             => $options['site_animation']
) );

$wp_customize->add_control( 'business_park_theme_options[site_animation]', array(
	'label'               => esc_html__( 'Enable Site Animation', 'business-park-pro' ),
	'section'             => 'business_park_layout',
	'type'                => 'checkbox',
) );

// Make rounded edges setting and control.
$wp_customize->add_setting( 'business_park_theme_options[make_rounded_design]', array(
	'sanitize_callback'   => 'business_park_sanitize_checkbox',
	'default'             => $options['make_rounded_design']
) );

$wp_customize->add_control( 'business_park_theme_options[make_rounded_design]', array(
	'label'               => esc_html__( 'Enable Rounded Design', 'business-park-pro' ),
	'section'             => 'business_park_layout',
	'type'                => 'checkbox',
) );