<?php
// Add copyright section
$wp_customize->add_section( 'business_park_loader', array(
	'title'               => esc_html__( 'Loader','business-park-pro' ),
	'description'         => esc_html__( 'Loader section options.', 'business-park-pro' ),
	'panel'               => 'business_park_theme_options_panel'
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[loader_enable]', array(
	'sanitize_callback'   => 'business_park_sanitize_checkbox',
	'default'             => $options['loader_enable']
) );

$wp_customize->add_control( 'business_park_theme_options[loader_enable]', array(
	'label'               => esc_html__( 'Enable loader', 'business-park-pro' ),
	'section'             => 'business_park_loader',
	'type'                => 'checkbox',
) );

// Loader type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[loader_type]', array(
	'sanitize_callback'   => 'business_park_sanitize_select',
	'default'             => $options['loader_type']
) );

$wp_customize->add_control( 'business_park_theme_options[loader_type]', array(
	'label'               => esc_html__( 'Loader Type', 'business-park-pro' ),
	'section'             => 'business_park_loader',
	'type'                => 'select',
	'active_callback'		 => 'business_park_is_loader_enable',
	'choices'				 => business_park_loader_type(),
) );

// Loader gif setting and control.
$wp_customize->add_setting( 'business_park_theme_options[loader_gif]', array(
	'sanitize_callback'   => 'business_park_sanitize_image',
	'default'             => $options['loader_gif']
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[loader_gif]', array(
	'label'               => esc_html__( 'Loader Image/Gif', 'business-park-pro' ),
	'section'             => 'business_park_loader',
	'active_callback'		 => 'business_park_is_loader_type_image'
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'business_park_theme_options[loader_icon]', array(
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( 'business_park_theme_options[loader_icon]', array(
	'label'           => esc_html__( 'Icon', 'business-park-pro' ),
	'section'         => 'business_park_loader',
	'active_callback' => 'business_park_is_loader_type_icon',
	'type'				=> 'text',
	'input_attrs'		=> array( 'placeholder' => esc_html__( 'fa-archive', 'business-park-pro' ), )
) );