<?php
/**
* Pagination options
*
* @package Theme Palace
* @subpackage Business_Park_Pro
* @since Business Park Pro 2.0.0
*/

// Add copyright section
$wp_customize->add_section( 'business_park_pagination', array(
	'title'       => esc_html__('Pagination','business-park-pro'),
	'description' => sprintf( esc_html__( 'Infinite Scroll Options requires %1$sJetPack%2$s Plugin with Infinite Scroll module Enabled.', 'business-park-pro' ), '<a target="_blank" href="' . esc_url( 'https://wordpress.org/plugins/jetpack/' ) . '">', '</a>' ),
	'panel'       => 'business_park_theme_options_panel'
) );

// Disable Pagination setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_pagination]', array(
	'sanitize_callback' => 'business_park_sanitize_checkbox',
	'default'           => $options['enable_pagination']
) );

$wp_customize->add_control( 'business_park_theme_options[enable_pagination]', array(
	'label'   => esc_html__( 'Check to enable pagination', 'business-park-pro' ),
	'section' => 'business_park_pagination',
	'type'    => 'checkbox'
) );

// Disable Pagination type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pagination_type]', array(
	'sanitize_callback' => 'business_park_sanitize_select',
	'default'           => $options['pagination_type']
) );

$wp_customize->add_control( 'business_park_theme_options[pagination_type]', array(
	'label'           => esc_html__( 'Pagination type ( Only on Archives )', 'business-park-pro' ),
	'section'         => 'business_park_pagination',
	'type'            => 'select',
	'choices'         => business_park_pagination_type(),
	'active_callback' => 'business_park_is_pagination_enable'
) );