<?php
/**
 * Moral OCDI plugin compatible functions
 *
 * @package Moral
 */

function business_park_ctdi_plugin_page_setup( $default_settings ) {
    $default_settings['menu_title']  = esc_html__( 'Theme Palace Demo Import' , 'business-park-pro' );

    return $default_settings;
}
add_filter( 'cp-ctdi/plugin_page_setup', 'business_park_ctdi_plugin_page_setup' );


function business_park_ctdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Pro', 'business-park-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/pro/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/pro/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/pro/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/pro/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'business-park-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/business-park-pro/',
        ),
        
    );
}
add_filter( 'cp-ctdi/import_files', 'business_park_ctdi_import_files' );



function business_park_ctdi_after_import_setup() {
    // Assign menus to their locations.
    $top = get_term_by( 'name', 'Top', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'top' => $top->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'cp-ctdi/after_import', 'business_park_ctdi_after_import_setup' );
