<?php
/**
 * Business Park options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


/**
 * Enable options of the defined section
 * @return array Enable options
 */
function business_park_enable_options() {
	$business_park_enable_options = array(
		'static-frontpage' => esc_html__( 'Static Frontpage', 'business-park-pro' ),
		'entire-site'      => esc_html__( 'Entire Site', 'business-park-pro' ),
		'disabled'         => esc_html__( 'Disabled', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_enable_options', $business_park_enable_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}

/**
 * Primary menu types
 * @return array Prmary menu type
 */
function business_park_primary_menu_type() {
	$business_park_primary_menu_type = array(
		'mega'  => esc_html__( 'Mega', 'business-park-pro' ),
		'simple' => esc_html__( 'Simple', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_primary_menu_type', $business_park_primary_menu_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Primary menu position
 * @return array Prmary menu positon
 */
function business_park_primary_menu_position() {
	$business_park_primary_menu_position = array(
		'top'  => esc_html__( 'Top', 'business-park-pro' ),
		'below-slider' => esc_html__( 'Below Slider', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_primary_menu_position', $business_park_primary_menu_position );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Common content types
 * @return array Content types
 */
function business_park_content_type() {
	$business_park_content_type = array(
		'demo' 		=> esc_html__( 'Demo', 'business-park-pro' ),
		'page'		=> esc_html__( 'Page', 'business-park-pro' ),
		'post'		=> esc_html__( 'Post', 'business-park-pro' ),
		'custom'		=> esc_html__( 'Custom', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_content_type', $business_park_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Team content types
 * @return array Content types
 */
function business_park_team_content_type() {
	$business_park_team_content_type = array(
		'demo' 		=> esc_html__( 'Demo', 'business-park-pro' ),
		'page'		=> esc_html__( 'Page', 'business-park-pro' ),
		'post'		=> esc_html__( 'Post', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_team_content_type', $business_park_team_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Testimonial content types
 * @return array Content types
 */
function business_park_testimonial_content_type() {
	$business_park_testimonial_content_type = array(
		'demo'        => esc_html__( 'Demo', 'business-park-pro' ),
		'category' => esc_html__( 'Category', 'business-park-pro' ),
	);
	if ( business_park_is_jetpack_cpt_module_enable( 'jetpack_testimonial' ) ) {
		$business_park_testimonial_content_type['testimonial'] = esc_html__( 'Testimonial', 'business-park-pro' );
	}
	$output = apply_filters( 'business_park_testimonial_content_type', $business_park_testimonial_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Testimonial background content types
 * @return array Content types
 */
function business_park_testimonial_bg_type() {
	$business_park_testimonial_bg_type = array(
		'image' => esc_html__( 'Image', 'business-park-pro' ),
		'video' => esc_html__( 'Video', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_testimonial_bg_type', $business_park_testimonial_bg_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Portfoli content types
 * @return array Content types
 */
function business_park_portfolio_content_type() {
	$business_park_portfolio_content_type = array(
		'demo'               => esc_html__( 'Demo', 'business-park-pro' ),
		'category'           => esc_html__( 'Category', 'business-park-pro' ),
	);
	if ( business_park_is_jetpack_cpt_module_enable( 'jetpack_portfolio' ) ) {
		$business_park_portfolio_content_type['portfolio-category'] = esc_html__( 'Portfolio Category', 'business-park-pro' );
	}
	$output = apply_filters( 'business_park_portfolio_content_type', $business_park_portfolio_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Logo Slider content types
 * @return array Content types
 */
function business_park_logo_slider_content_type() {
	$business_park_logo_slider_content_type = array(
		'demo'               => esc_html__( 'Demo', 'business-park-pro' ),
		'custom'           => esc_html__( 'Custom', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_logo_slider_content_type', $business_park_logo_slider_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Logo Slider content types
 * @return array Content types
 */
function business_park_pricing_content_type() {
	$business_park_pricing_content_type = array(
		'demo'               => esc_html__( 'Demo', 'business-park-pro' ),
		'post'           => esc_html__( 'Post', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_pricing_content_type', $business_park_pricing_content_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Slider effects
 * @return array Slider effects
 */
function business_park_slider_effect() {
	$business_park_slider_effect = array(
		'scrollHorz' => esc_html__( 'Scroll Horizontal', 'business-park-pro' ),
		'scrollVert' => esc_html__( 'Scroll Vertical', 'business-park-pro' ),
		'fadeout'    => esc_html__( 'Fade Out', 'business-park-pro' ),
		'flipHorz'   => esc_html__( 'Flip Horizontal', 'business-park-pro' ),
		'flipVert'   => esc_html__( 'Flip Vertical', 'business-park-pro' ),
		'shuffle'    => esc_html__( 'Shuffle', 'business-park-pro' ),
	);

	$output =  apply_filters( 'business_park_slider_effect', $business_park_slider_effect );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Blog content types
 * @return array Content types
 */
function business_park_blog_content_type() {
	$business_park_blog_content_type = array(
		'demo'        => esc_html__( 'Demo', 'business-park-pro' ),
		'post'        => esc_html__( 'Choose Posts', 'business-park-pro' ),
		'recent-post' => esc_html__( 'Recent Posts', 'business-park-pro' ),
		'category'    => esc_html__( 'Show by Category', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_blog_content_type', $business_park_blog_content_type );

	return $output;
}


/**
 * List of pagination types
 * @return array Pagination types
 */
function business_park_pagination_type() {
	$business_park_pagination_type = array(
		'numeric'         => esc_html__( 'Numeric', 'business-park-pro' ),
		'older-newer'     => esc_html__( 'Older/Newer', 'business-park-pro' ),
	);

	if ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'infinite-scroll' ) ) {
		$business_park_pagination_type['infinite-click'] = 'Infinite Click';
		$business_park_pagination_type['infinite-scroll'] = 'Infinite Scroll';
	}
	$output = apply_filters( 'business_park_pagination_type', $business_park_pagination_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}



/**
 * List of color layout
 * @return array Color layout options
 */
function business_park_color_layouts() {
	$business_park_color_layouts = array(
		'default'  => esc_html__( 'Default', 'business-park-pro' ),
		'red'      => esc_html__( 'Red', 'business-park-pro' ),
		'black'    => esc_html__( 'Black', 'business-park-pro' ),
		'brown'    => esc_html__( 'Brown', 'business-park-pro' ),
		'cyan'     => esc_html__( 'Cyan', 'business-park-pro' ),
		'gray'     => esc_html__( 'Gray', 'business-park-pro' ),
		'orange'   => esc_html__( 'Orange', 'business-park-pro' ),
		'purple'   => esc_html__( 'Purple', 'business-park-pro' ),
		'red'      => esc_html__( 'Red', 'business-park-pro' ),
		'blue'      => esc_html__( 'Blue', 'business-park-pro' ),
		'sky-blue' => esc_html__( 'Sky Blue', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_color_layouts', $business_park_color_layouts );

	return $output;
}


/**
 * Archive Content types
 * @return array Pagination types
 */
function business_park_archive_content() {
	$business_park_archive_content = array(
		'excerpt'      => esc_html__( 'Excerpt', 'business-park-pro' ),
		'full-content' => esc_html__( 'Full content', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_archive_content', $business_park_archive_content );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Archive Content types
 * @return array Pagination types
 */
function business_park_loader_type() {
	$business_park_loader_type = array(
		'image-gif' => esc_html__( 'Image/Gif', 'business-park-pro' ),
		'icon'     => esc_html__( 'Icon', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_loader_type', $business_park_loader_type );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}


/**
 * Sidebar position
 * @return array Sidbar positions
 */
function business_park_sidebar_position() {
	$business_park_sidebar_position = array(
		'right-sidebar' => esc_html__( 'Right', 'business-park-pro' ),
		'left-sidebar'  => esc_html__( 'Left', 'business-park-pro' ),
		'no-sidebar'    => esc_html__( 'No Sidebar', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_sidebar_position', $business_park_sidebar_position );

	return $output;
}


/**
 * Site Layout
 * @return array Sidbar positions
 */
function business_park_site_layout() {
	$business_park_site_layout = array(
		'wide'  => esc_html__( 'Wide', 'business-park-pro' ),
		'boxed' => esc_html__( 'Boxed', 'business-park-pro' ),
	);

	$output = apply_filters( 'business_park_site_layout', $business_park_site_layout );

	return $output;
}
