<?php
/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_about_section' ) ) :
    /**
     * Add about section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_about_section() {

        // Check if about is enabled on frontpage
        $about_enable = apply_filters( 'business_park_section_status', true, 'about_enable' );
        if ( true !== $about_enable ) {
            return false;
        }

        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about section now.
        business_park_render_about_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_about_section', 10 );


if ( ! function_exists( 'business_park_get_about_section_details' ) ) :
    /**
     * About section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input About section details.
     */
    function business_park_get_about_section_details( $input ) {
        $options = business_park_get_theme_options();

        // About type
        $about_content_type    = $options['about_content_type'];

        $content = array();
        switch ( $about_content_type ) {
            case 'demo':
                $content['img_array'][0] = get_template_directory_uri() . '/assets/uploads/about-1.jpg';
                $content['img_array'][1] = 400;
                $content['img_array'][2] = 200;
                $content['url']      = '#';
                $content['title']    = esc_html__( 'about us', 'business-park-pro' );
                $content['excerpt']  = esc_html__( 'In gnissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi.', 'business-park-pro' );
            break;

            case 'custom':
                if ( isset( $options[ 'about_content_custom_image'] ) ) {
                    $content['img_array'][0] = $options['about_content_custom_image'];
                }
                $content['img_array'][1] = 400;
                $content['img_array'][2] = 200;
                if ( isset( $options[ 'about_content_custom_image_url'] ) ) {
                    $content['url']      = $options['about_content_custom_image_url'];
                }
                if ( isset( $options[ 'about_content_custom_title'] ) ) {
                    $content['title']    = $options['about_content_custom_title'];
                }
                if ( isset( $options[ 'about_content_custom_title'] ) ) {
                    $content['excerpt']  = $options['about_content_custom_content'];
                }
            break;

            case 'page':
                $post_id = null;
                if ( isset( $options[ 'about_content_page'] ) ) {
                    $post_id = absint( $options[ 'about_content_page'] );
                }

            break;

            case 'post':
                $post_id = null;
                if ( isset( $options[ 'about_content_post'] ) ) {
                    $post_id = absint( $options[ 'about_content_post'] );
                }

            break;

            default:
            break;
        }
        if ( in_array( $about_content_type, array( 'post', 'page' ) ) ) {
            if ( ! empty( $post_id ) ) {

                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'business-park-pro-about' );

                    $content['img_array'] = $img_array;
                }

                $content['url']      = get_permalink( $post_id );
                $content['title']    = get_the_title( $post_id );
                $content['excerpt']  = business_park_trim_content( get_post( $post_id ), 80 );
            }
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;

    }
endif;
// ABout section content details.
add_filter( 'business_park_filter_about_section_details', 'business_park_get_about_section_details' );


if ( ! function_exists( 'business_park_about_section_layout' ) ) :
    /**
     * About section layout.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input About section details.
     */
    function business_park_about_section_layout( $classes = array() ) {
        $options = business_park_get_theme_options();
        $about_content_type    = $options['about_content_type'];

        if ( 'demo' == $about_content_type ) {
                $classes[] = 'half-column';
        } else {
            if ( isset( $options[ 'about_content_page'] ) ) {
                    $about_page_id = absint( $options[ 'about_content_page'] );
            }

            if ( ! empty( $about_page_id ) ){
                if ( has_post_thumbnail( $about_page_id ) ) {
                    $classes[] = 'half-column';
                } else {
                    $classes[] = 'full-column';
                }
                array_unique( $classes );
            }
        }

        return $classes;
    }
endif;
// About section layout
add_filter( 'business_park_filter_about_section_layout', 'business_park_about_section_layout' );


if ( ! function_exists( 'business_park_render_about_section' ) ) :
    /**
     * Start section id .about
     *
     * @return string about content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_about_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        $classes = apply_filters( 'business_park_filter_about_section_layout', array() );
        $classes = implode( '', $classes );

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="about" class="bg-white">
            <div class="container">
                <div class="entry-content">
                    <div class="about-wrapper">
                        <?php if (  $content_details['excerpt'] ) { ?>
                            <div class="<?php echo esc_attr( $classes );?> os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
                                <header class="entry-header">
                                    <h2 class="entry-title"><?php echo esc_html( $content_details['title'] );?></h2>
                                </header>
                                <p class="description"><?php echo esc_html( $content_details['excerpt'] );?></p>
                                <a href="<?php echo esc_url( $content_details['url'] );?>" class="more-link"><?php esc_html_e( 'Learn More', 'business-park-pro' ); ?><i class="fa fa-long-arrow-right"></i></a>
                            </div>
                        <?php } ?>
                        <?php if ( ! empty( $content_details['img_array'][0] ) ) { ?>
                            <div class="half-column os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
                                <div class="ImageWrapper">
                                    <a href="<?php echo esc_url( $content_details['url'] );?>">
                                        <img src="<?php echo esc_url( $content_details['img_array'][0] );?>" /></a>
                                    <a href="<?php echo esc_url( $content_details['url'] );?>"><i class="fa fa-link"></i></a>
                                    <div class="ImageOverlayLi"></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div><!--end about-wrapper-->
                </div><!--end entry-content-->
            </div><!--end container-->
        </section>

<?php
    }
endif;