<?php
/**
 * Blog section
 *
 * This is the template for the content of Blog section in front page
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */
if ( ! function_exists( 'business_park_add_blog_section' ) ) :
    /**
     * Add Blog section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_blog_section() {

        // Check if Blog is enabled on frontpage
        $blog_enable = apply_filters( 'business_park_section_status', true, 'blog_enable' );
        if ( true !== $blog_enable ) {
            return false;
        }

        // Get Blog section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Blog section now.
        business_park_render_blog_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_blog_section', 80 );


if ( ! function_exists( 'business_park_get_blog_section_details' ) ) :
    /**
     * Blog section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input Blog section details.
     */
    function business_park_get_blog_section_details( $input ) {
        $options = business_park_get_theme_options();

        // Slider type
        $slider_content_type    = $options['blog_content_type'];

        $content = array();

        switch ( $slider_content_type ) {
            case 'demo':
                for ( $i=1; $i<4; $i++ ) {
                    $content[$i]['img_array'][0] = get_template_directory_uri() . '/assets/uploads/blog_0'.$i.'.jpg';
                    $content[$i]['img_array'][1] = 300;
                    $content[$i]['img_array'][2] = 600;
                    $content[$i]['url']     = '#';
                    $content[$i]['title']   = esc_html__( 'Blog title', 'business-park-pro' );
                    $content[$i]['excerpt'] = esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed condimentum aliquet venenatis', 'business-park-pro' );
                    $content[$i]['date']    = date_i18n( '12 January 2016' );
                    $content[$i]['author']    = esc_html__( 'Author', 'business-park-pro' );
                    $content[$i]['author_url']    = '#';
                    $content[$i]['comment_num']    = 10;
                }
            break;

            case 'recent-post':
                $i = 1;

                $args = array(
                    'posts_per_page'      => $options['blog_count'],
                    'ignore_sticky_posts' => true,
                );
            break;

            case 'category':
                if ( empty( $options['blog_content_category'] ) ) {
                    return $input;
                }
                $args = array(
                    'posts_per_page'      => $options['blog_count'],
                    'ignore_sticky_posts' => true,
                    'cat'                 => $options['blog_content_category']
                );
            break;

            case 'post':
                $ids = array();

                for ( $i = 1; $i <= $options['blog_count']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'blog_content_post_'.$i ] ) ) {
                        $id = $options[ 'blog_content_post_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'posts_per_page'      => $options['blog_count'],
                    'ignore_sticky_posts' => true,
                    'post__in'            => $ids
                );
            break;

            default:
            break;
        }

        if ( 'demo' != $slider_content_type ) {
            $query = new WP_Query( $args );
            $j = 1;

            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();

                    $img_array = null;

                    if ( has_post_thumbnail() ) {
                            $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'post-thumbnail' );
                        } else {
                            $img_array = business_park_dummy_image( 600, 300 );
                        }

                        if ( isset( $img_array ) ) {
                            $content[$j]['img_array'] = $img_array;
                        }

                        $content[$j]['url']     = get_permalink();
                        $content[$j]['title']   = get_the_title();
                        $content[$j]['excerpt'] = get_the_excerpt();
                        $content[$j]['date']    = get_the_date();
                        $content[$j]['author']    = get_the_author();
                        $content[$j]['author_url']    = get_author_posts_url( get_the_author_meta( 'ID' ) );
                        $content[$j]['comment_num']    = get_comments_number();

                    $j++;
                }
            }
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Blog section content details.
add_filter( 'business_park_filter_blog_section_details', 'business_park_get_blog_section_details' );

if ( ! function_exists( 'business_park_render_blog_section' ) ) :
    /**
     * Start section id .Blog
     *
     * @return string Blog content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_blog_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="blog-section" class="bg-white">
            <div class="container">
                <?php if ( ! empty( $options['blog_title'] ) ) : ?>
                    <header class="entry-header">
                        <h2 class="entry-title"><?php echo esc_html( $options['blog_title'] );?></h2>
                    </header>
                <?php endif; ?>
                <div class="entry-content">
                    <div class="blog-wrapper clear">
                        <?php foreach ($content_details as $content ) { ?>
                            <div class="blog-post-section os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="0.3s">
                                <div class="posted-date">
                                    <span><?php echo date_i18n( get_option( 'date_format' ), strtotime( $content['date'] ) ); ?></span>
                                </div>
                                <div class="blog-box">
                                    <div class="blog-image">
                                        <div class="ImageWrapper">
                                            <a href="<?php echo esc_url( $content['url'] ); ?>"><img width="<?php echo esc_attr( $content['img_array'][1] );?>" height="<?php echo esc_attr( $content['img_array'][2] );?>" src="<?php echo esc_url( $content['img_array'][0] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                        </div>
                                    </div>
                                    <div class="blog-title">
                                        <h5><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h5>
                                    </div>
                                    <div class="blog-desc">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                        <?php  
                                        // Author
                                        $byline = '<span class="author vcard"><span class="screen-reader-text">'.esc_html__( 'Posted By', 'business-park-pro' ).'</span><a class="url fn n" href="' . esc_url( $content['author_url'] ) . '">' . esc_html( $content['author'] ) . '</a></span>';
                                        // Comment 
                                        $comment =  '<span class="comments-link"><i class="fa fa-comments"></i>' . absint( $content['comment_num'] ) . '</span>';
                                        echo '<div class="entry-meta">' . $byline . $comment . '</div>';
                                        ?>
                                    </div>
                                    <div class="share-blog"></div>
                                </div><!--end .blog-box-->
                            </div><!--end .blog-post-->
                        <?php } ?>
                    </div><!--end .blog-wrapper-->
                    <?php
                    $page_for_posts_id = get_option( 'page_for_posts' );
                    if ( $page_for_posts_id != 0 ) { ?>
                        <div class="blog-archive">
                            <a href="<?php echo esc_url( get_permalink( $page_for_posts_id ) ); ?>" class="more-link"><?php esc_html_e( 'VISIT OUR BLOG ARCHIVE HERE', 'business-park-pro' );?><i class="fa fa-long-arrow-right"></i></a>
                        </div>
                        <div class="green-separator"></div>
                    <?php } ?>
                </div><!--end .entry-content-->
            </div><!--end .container-->
        </section>

<?php
    }
endif;