<?php
/**
 * Features section
 *
 * This is the template for the content of features section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_features_section' ) ) :
    /**
     * Add Features section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_features_section() {

        // Check if Features is enabled on frontpage
        $features_enable = apply_filters( 'business_park_section_status', true, 'features_enable' );
        if ( true !== $features_enable ) {
            return false;
        }

        // Get Features section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_features_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Features section now.
        business_park_render_features_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_features_section', 80 );


if ( ! function_exists( 'business_park_get_features_section_details' ) ) :
    /**
     * Features section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input Features section details.
     */
    function business_park_get_features_section_details( $input ) {
      $options = business_park_get_theme_options();
      // Slider type
      $features_content_type  = $options['features_content_type'];

      $content = array();

      switch ( $features_content_type ) {
        case 'demo':
          for ( $i=0; $i<4; $i++ ) {
            $icons = array( 'fa-desktop', 'fa-gear', 'fa-star-o', 'fa-cubes' );
            $features_name = array( 'SHORTCODES', 'INTEGRATED PLUGINS', 'CREATIVE PRODUCTS', 'CLIENTS WORLDWIDE' );

            $content[ $i ]['features_icon'] = $icons[ $i ];
            $content[ $i ]['features_name'] = $features_name[ $i ];
            $content[ $i ]['features_count'] = 65;
            $content[ $i ]['features_icon_color'] = '';
          }
        break;

        case 'custom':
          for ( $i = 1; $i <= $options['features_count']; $i++ ) {
            if ( isset( $options[ 'features_icon_'.$i ] ) ) {
              $content[ $i ]['features_icon'] = $options[ 'features_icon_'.$i ];
            }
            if ( isset( $options[ 'features_name_'.$i ] ) ) {
              $content[ $i ]['features_name'] = $options[ 'features_name_'.$i ];
            }
            if ( isset( $options[ 'features_count_'.$i ] ) ) {
              $content[ $i ]['features_count'] = $options[ 'features_count_'.$i ];
            }
            if ( ! empty( $options[ 'features_icon_color_'.$i ] ) ) {
              $content[ $i ]['features_icon_color'] = $options[ 'features_icon_color_'.$i ];
            }
          }
        break;
      }

      if ( ! empty( $content ) ) {
          $input = $content;
      }

      return $input;
    }
endif;
// Features section content details.
add_filter( 'business_park_filter_features_section_details', 'business_park_get_features_section_details' );


if ( ! function_exists( 'business_park_render_features_section' ) ) :
    /**
     * Start section id .pie-chart
     *
     * @return string pie-chart content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_features_section( $content_details = array() ) {
        $options = business_park_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="features" class="bg-white">
            <div class="container">
                <?php if ( ! empty( $options['features_section_title'] ) ) : ?>
                  <header class="entry-header">
                      <h2 class="entry-title"><?php echo esc_html( $options['features_section_title'] );?></h2>
                  </header>
                <?php endif; ?>
                <div class="entry-content">
                    <div class="statscounts text-center">
                      <?php foreach ( $content_details as $content ) {
                        if ( ! empty( $content['features_icon'] ) ||  ! empty( $content['features_name'] ) ||  ! empty( $content['features_count'] ) ) { ?>
                          <div class="statwrap icon-animation icon-hover-effect four-col os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
                              <i style="color:<?php
                                if ( ! empty( $content['features_icon_color'] ) ) {
                                  echo esc_attr( $content['features_icon_color'] );
                                 }
                              ?>"
                              class="fa <?php echo esc_attr( $content['features_icon'] );?> icon-hover"></i>
                              
                              <?php if ( ! empty( $content['features_count'] ) ) {?>
                                <span class="stat-count">
                                  <?php echo absint( $content['features_count'] ); ?>
                                </span>
                              <?php } ?>

                              <?php if ( ! empty( $content['features_name'] ) ) { ?>
                                <small><?php echo esc_html( $content['features_name'] );?></small>
                              <?php }?>
                          </div><!-- end col -->
                        <?php
                         }
                      } ?>
                    </div><!-- end row -->
                    <div class="green-separator"></div>
                </div><!--end entry-content -->
            </div><!--end sectionn-layout-->
        </section>

<?php
    }
endif;