<?php
/**
 * Logo slider section
 *
 * This is the template for the content of logo slider section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_logo_slider_section' ) ) :
    /**
     * Add Logo Slider section
     *
     * @since Business Park Pro 2.0.0
@since 1.0
     */
    function business_park_add_logo_slider_section() {

      // Check if Logo Slider is enabled on frontpage
      $logo_slider_enable = apply_filters( 'business_park_section_status', true, 'logo_slider_enable' );
      if ( true !== $logo_slider_enable ) {
          return false;
      }

      // Get Logo Slider section details
      $section_details = array();
      $section_details = apply_filters( 'business_park_filter_logo_slider_section_details', $section_details );

      if ( empty( $section_details ) ) {
          return;
      }

      // Render Logo Slider section now.
      business_park_render_logo_slider_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_logo_slider_section', 40 );


if ( ! function_exists( 'business_park_get_logo_slider_section_details' ) ) :
    /**
     * Logo Slider section details.
     *
     * @since Business Park Pro 2.0.0
@since 1.0
     *
     * @param array $input Logo Slider section details.
     */
    function business_park_get_logo_slider_section_details( $input ) {
        $options = business_park_get_theme_options();

        // Logo Slider type
        $logo_slider_content_type = $options['logo_slider_content_type'];

        $content = array();
        switch ( $logo_slider_content_type ) {

            case 'custom':
              for ( $i = 1; $i <= $options['logo_slider_content_count']; $i++ ) {
                  if ( ! empty( $options[ 'logo_slider_image_'.$i ] ) ) {
                      $content[ $i ]['img_url'] = $options[ 'logo_slider_image_'.$i ];

                      if ( isset( $options[ 'logo_slider_image_url_'.$i ] ) ) {
                          $content[ $i ]['url'] = $options[ 'logo_slider_image_url_'.$i ];
                      }

                      if ( isset( $options[ 'logo_slider_image_alt_'.$i ] ) ) {
                          $content[ $i ]['alt'] = $options[ 'logo_slider_image_alt_'.$i ];
                      }
                  }

              }
            break;

            case 'demo':
              for ( $i = 1; $i <= 5 ; $i++ ) {
                $content[ $i ]['img_url'] = get_template_directory_uri() . '/assets/uploads/logo-'.$i.'.png';

                $content[ $i ]['url'] = '#';

                $content[ $i ]['alt'] = sprintf( esc_html__( 'Logo %s', 'business-park-pro' ), $i );
              }
            break;

            default:
            break;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;

    }
endif;
// Logo Slider section content details.
add_filter( 'business_park_filter_logo_slider_section_details', 'business_park_get_logo_slider_section_details' );


if ( ! function_exists( 'business_park_render_logo_slider_section' ) ) :
    /**
     * Start section id .logo-carousel
     *
     * @return string logo carousel content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_logo_slider_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="logo-carousel">
            <div class="overlay"></div><!-- end overlay -->
            <div class="container">
                <div class="entry-content">
                    <div id="logo-testimonial" class="cycle-slideshow" data-cycle-timeout="3000"  data-cycle-carousel-fluid="true" data-cycle-fx="carousel" data-cycle-carousel-visible="<?php echo absint( count( $content_details ) );?>" data-cycle-slides=">a" data-cycle-next="#next1" data-cycle-prev="#prev1">
                      <?php foreach ( $content_details as $content ) {
                              if ( ! empty( $content['img_url'] ) ) {
                                ?>
                                <a href="
                                  <?php if ( ! empty( $content['url'] ) ) {
                                    echo esc_url( $content['url'] );
                                  };?>">
                                  <img src="<?php echo esc_url( $content['img_url'] );?>" alt="
                                  <?php
                                    if ( ! empty( $content['alt'] ) ) {
                                      echo esc_attr( $content['alt'] );
                                    }
                                  ?>">
                                </a>
                      <?php }
                    } ?>
                    </div><!--end cycle-slideshow-->

                     <div class="controls">
                         <div class="cycle-prev"><a href="#" id="prev1"><i class="fa fa-angle-left"></i></a></div>
                         <div class="cycle-next"><a href="#" id="next1"><i class="fa fa-angle-right"></i></a></div>
                     </div><!--end controls-->
                 </div><!-- end entry-content -->
            </div><!-- end container -->
        </section>

<?php
    }
endif;