<?php
/**
 * Map section
 *
 * This is the template for the content of map section
 *
 * @package Theme Palace
 * @subpackage Business_Park Pro
 * @since Business Park Pro 2.0.0
 */


if ( ! function_exists( 'business_park_map_section' ) ) :
	/**
	 * Map section
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_map_section() {
		// Check if map is enabled on frontpage
	   	$options = business_park_get_theme_options();
		$map_enable = apply_filters( 'business_park_section_status', true, 'map_enable' );
		if ( true !== $map_enable || empty( $options['google_map_shortcode'] ) ) {
		    return false;
		} ?>
      <section class="map os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
          <div class="entry-content">
          		<?php echo do_shortcode( $options['google_map_shortcode'] );?>
          </div><!-- end .entry-content-->
      </section>
		<?php


		}
endif;
add_action( 'business_park_primary_content_end', 'business_park_map_section', 120 );