<?php
/**
 * Pie chart section
 *
 * This is the template for the content of pie chart section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


if ( ! function_exists( 'business_park_add_pie_chart_section' ) ) :
    /**
     * Add pie chart section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_pie_chart_section() {

        // Check if pie chart is enabled on frontpage
        $pie_chart_enable = apply_filters( 'business_park_section_status', true, 'pie_chart_enable' );
        if ( true !== $pie_chart_enable ) {
            return false;
        }

        // Get pie chart section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_pie_chart_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render pie chart section now.
        business_park_render_pie_chart_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_pie_chart_section', 60 );


if ( ! function_exists( 'business_park_get_pie_chart_section_details' ) ) :
    /**
     * Pie chart section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input pie chart section details.
     */
    function business_park_get_pie_chart_section_details( $input ) {
        $options = business_park_get_theme_options();

        // Pie chart type
        $pie_chart_content_type  = $options['pie_char_content_type'];

        $content = array();

        switch ( $pie_chart_content_type ) {
          case 'demo':
            for ( $i=0; $i<4; $i++ ) {
              $title = array( 'web design', 'Marketing', 'Html / css', 'ui / ux' );
              $value = array( 85, 40, 60, 85 );

              $content[ $i ]['chart_title'] = $title[ $i ];
              $content[ $i ]['chart_value'] = $value[ $i ];
            }
          break;
          case 'custom':

            for ( $i = 0; $i <= 4 ; $i++ ) {
              if ( isset( $options[ 'chart_title_'.$i ] ) ) {
                $content[ $i ]['chart_title'] = $options[ 'chart_title_'.$i ];
              }
              if ( isset( $options[ 'chart_value_'.$i ] ) ) {
                $content[ $i ]['chart_value'] = $options[ 'chart_value_'.$i ];
              }
            }
          break;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }

        return $input;
    }
endif;
// Pie chart section content details.
add_filter( 'business_park_filter_pie_chart_section_details', 'business_park_get_pie_chart_section_details' );


if ( ! function_exists( 'business_park_render_pie_chart_section' ) ) :
    /**
     * Start section id .pie-chart
     *
     * @return string pie-chart content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_pie_chart_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        $allowed_tags =  array(
              'span' => array(
                'class' => array(),
                'id'    => array(),
                'style' => array()
              ) );

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="pie-chart" class="bg-white">
          <div class="container">
            <?php if ( ! empty( $options['pie_chart_section_title'] ) ) : ?>
                <header class="entry-header">
                    <h2 class="entry-title"><?php echo wp_kses( $options['pie_chart_section_title'], $allowed_tags );?></h2>
                </header>
            <?php endif; ?>
            <div class="entry-content">
                <div class="counter os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
                  <?php
                    $i = 1;
                    foreach ( $content_details as $content ) {
                        if ( ! empty( $content['chart_value'] ) ) { ?>
                        <div class="count-box">
                            <div id="pie-chart-<?php echo $i; ?>" data-percent="<?php echo absint( $content['chart_value'] );?>"> <span class="pie-value"><?php echo absint( $content['chart_value'] );?>%</span></div>
                            <?php if ( ! empty( $content['chart_title'] ) ) { ?>
                                <h4><?php echo esc_html( $content['chart_title'] );?></h4>
                            <?php } ?>
                        </div><!--end count-box-->
                        <?php
                        }
                    $i++;
                  } ?>
                </div><!--end counter-->
            </div><!-- end entry-content-->
          </div><!-- end .container -->
        </section>

<?php
    }
endif;
