<?php
/**
 * Pricing section
 *
 * This is the template for the content of pricing section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


if ( ! function_exists( 'business_park_add_pricing_section' ) ) :
  /**
   * Add Pricing section
   *
   * @since Business Park Pro 2.0.0
@since 1.0
   */
  function business_park_add_pricing_section() {

    // Check if Pricing is enabled on frontpage
    $pricing_enable = apply_filters( 'business_park_section_status', true, 'pricing_enable' );
    if ( true !== $pricing_enable ) {
      return false;
    }

    // Get Pricing section details
    $section_details = array();
    $section_details = apply_filters( 'business_park_filter_pricing_section_details', $section_details );

    if ( empty( $section_details ) ) {
      return;
    }

    // Render Pricing section now.
    business_park_render_pricing_section( $section_details );
  }
endif;
add_action( 'business_park_primary_content', 'business_park_add_pricing_section', 70 );


if ( ! function_exists( 'business_park_get_pricing_section_details' ) ) :
  /**
   * Pricing section details.
   *
   * @since Business Park Pro 2.0.0
@since 1.0
   *
   * @param array $input Pricing section details.
   */
  function business_park_get_pricing_section_details( $input ) {
    $options = business_park_get_theme_options();

    // Pricing type
    $pricing_content_type  = $options['pricing_content_type'];

    $content = array();

    switch ( $pricing_content_type ) {
      case 'demo':
        for ( $i=0; $i<4; $i++ ) {
          $colors = array( 'green', 'grey', 'yellow', 'red' );

          $title = array( '<span>Basic</span><h2>FREE</h2>', '<span>Standard</span><h2>$24.00</h2>', '<span>Premium</span><h2>$40.00</h2>', '<span>Professional</span><h2>$75.00</h2>' );
          $content[ $i ]['url']     = '#';
          $content[ $i ]['title']   = $title[ $i ];
          $content[ $i ]['excerpt'] = '<ul>
                                        <li>20 Pages</li>
                                        <li>2 GB Storage</li>
                                        <li>150 Members</li>
                                        <li>2 Contributors</li>
                                      </ul>';
          $content[ $i ]['color']   = $colors[ $i ];
        }
      break;

      case 'page':
        $ids = array();

        for ( $i = 1; $i <= $options['pricing_count']; $i++ ) {
            $id = null;
            if ( isset( $options[ 'pricing_page_'.$i ] ) ) {
                $id = $options[ 'pricing_page_'.$i ];
            }
            if ( ! empty( $id ) ) {
                $ids[] = absint( $id );
            }
        }

        // Bail if no valid pages are selected.
        if ( empty( $ids ) ) {
            return $input;
        }

        $args = array(
            'no_found_rows'  => true,
            'orderby'        => 'post__in',
            'post_type'      => 'page',
            'post__in'       => $ids,
        );
      break;

      case 'post':
        $ids = array();

        for ( $i = 1; $i <= $options['pricing_count']; $i++ ) {
            $id = null;
            if ( isset( $options[ 'pricing_content_post_'.$i ] ) ) {
                $id = $options[ 'pricing_content_post_'.$i ];
            }
            if ( ! empty( $id ) ) {
                $ids[] = absint( $id );
            }
        }

        // Bail if no valid pages are selected.
        if ( empty( $ids ) ) {
            return $input;
        }

        $args = array(
            'no_found_rows'  => true,
            'orderby'        => 'post__in',
            'post_type'      => 'post',
            'post__in'       => $ids,
        );
      break;

      default:
      break;
    }

    if ( 'demo' != $pricing_content_type ) {
      // Fetch posts.
      $posts = get_posts( $args );

      if ( ! empty( $posts ) ) {

        $i = 0;
        foreach ( $posts as $key => $post ) {
          $page_id = $post->ID;

          $colors = array( 'green', 'grey', 'yellow', 'red' );

          $content[$i]['url']     = get_permalink( $page_id );
          $content[$i]['title']   = get_the_title( $page_id );
          $content[$i]['excerpt'] = business_park_trim_content( $post, 20 );
          $content[$i]['color']   = $colors[$i];

          $i++;
        }
      }
    }

    if ( ! empty( $content ) ) {
      $input = $content;
    }
    return $input;

  }
endif;
// Pricing section content details.
add_filter( 'business_park_filter_pricing_section_details', 'business_park_get_pricing_section_details' );


if ( ! function_exists( 'business_park_render_pricing_section' ) ) :
  /**
   * Start section class .Pricing-section
   *
   * @return string Pricing content
   * @since Business Park Pro 2.0.0
   *
   */
  function business_park_render_pricing_section( $content_details = array() ) {
    $options = business_park_get_theme_options();

    if ( empty( $content_details ) ) {
      return;
    }

    $section_layout = apply_filters( 'business_park_filter_section_layout', $content_details );
    ?>

    <section id="pricing">
          <div class="overlay"></div>
          <div class="container">
              <?php if ( ! empty( $options['pricing_section_title'] ) ) : ?>
                <header class="entry-header">
                    <h2 class="entry-title"><?php echo esc_html( $options['pricing_section_title'] );?></h2>
                </header>
              <?php endif; ?>
              <div class="entry-content">
                <?php
                $i = 0;
                foreach ($content_details as $content ) { ?>
                  <div class="<?php echo esc_attr( $section_layout );?>-col">
                      <div class="pricing-table bg-white os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="0.3s">
                          <div class="pricing-table-header bg-<?php echo esc_attr( $content['color'] );?> text-center">
                              <span><?php echo wp_kses_post( $content['title'] );?></span>
                          </div><!-- end header -->
                          <div class="pricing-table-body text-center">
                              <?php echo wp_kses_post ( $content['excerpt'] );?>
                          </div><!-- end body -->
                          <div class="pricing-table-footer pricingbox text-center">
                              <a href="<?php echo esc_url( $content['url'] );?>" class="more-link"><?php esc_html_e( 'PURCHASE', 'business-park-pro' ); ?><i class="fa fa-long-arrow-right"></i></a>
                          </div><!-- end footer -->
                      </div><!-- end pricing-table -->
                  </div><!-- end four-col -->
                <?php $i++;
                } ?>
              </div><!-- end entry-content-->
          </div><!--end container-->
    </section>

<?php }
endif;