<?php
/**
 * Slider section
 *
 * This is the template for the content of slider section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_slider_section' ) ) :
	/**
	 * Add slider section
	 *
	 * @since Business Park Pro 2.0.0
	 */
	function business_park_add_slider_section() {

		// Check if slider is enabled on frontpage
		$slider_enable = apply_filters( 'business_park_section_status', true, 'slider_enable' );
		if ( true !== $slider_enable ) {
			return false;
		}

		// Get slider section details
		$section_details = array();
		$section_details = apply_filters( 'business_park_filter_slider_section_details', $section_details );

		if ( empty( $section_details ) ) {
			return;
		}

		// Render slider section now.
		business_park_render_slider_section( $section_details );
	}
endif;
add_action( 'business_park_before_header', 'business_park_add_slider_section', 30 );


if ( ! function_exists( 'business_park_get_slider_section_details' ) ) :
	/**
	 * Slider section details.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param array $input Slider section details.
	 */
	function business_park_get_slider_section_details( $input ) {
		$options = business_park_get_theme_options();

		// Slider type
		$slider_content_type 	= $options['slider_content_type'];

		$content = array();
		switch ( $slider_content_type ) {
			case 'demo':
				for ( $i=1; $i<3; $i++ ) {
					$content[ $i ]['img_array'][0]   = get_template_directory_uri() . '/assets/uploads/slider_0'.$i.'.jpg';
					$content[ $i ]['img_array'][1]   = 1920;
					$content[ $i ]['img_array'][2]   = 1080;
					$content[ $i ]['url']            = '#';
					$content[ $i ]['title']          = esc_html__( 'business theme', 'business-park-pro' );
					$content[ $i ]['excerpt']        = esc_html__( 'In gnissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas.', 'business-park-pro' );
					$content[ $i ]['alt']            = esc_html__( 'Slider Image', 'business-park-pro' );
					$content[ $i ]['icon']           = get_template_directory_uri() . '/assets/uploads/slider-logo_0'.$i.'.png';
					$content[ $i ]['read_more_text'] = esc_html__( 'Read More', 'business-park-pro' );
				}
			break;

			case 'custom':
				for ( $i=1; $i<=$options['slider_content_page_count']; $i++ ) {
					$content[ $i ]['img_array'][0]   = $options['slider_content_custom_image_'.$i];
					$content[ $i ]['img_array'][1]   = 1920;
					$content[ $i ]['img_array'][2]   = 1080;
					$content[ $i ]['url']            = $options['slider_content_custom_url_'.$i];
					$content[ $i ]['title']          = $options['slider_content_custom_title_'.$i];
					$content[ $i ]['excerpt']        = $options['slider_content_custom_desc_'.$i];
					$content[ $i ]['alt']            = $options['slider_content_custom_title_'.$i];
					if ( isset( $options['slider_content_custom_icon_'.$i] ) ) {
						$content[ $i ]['icon']           = $options['slider_content_custom_icon_'.$i];
					}

					$content[ $i ]['read_more_text'] = $options['slider_content_read_more_text'];
				}
			break;

			case 'page':
				$ids = array();

				for ( $i = 1; $i <= $options['slider_content_page_count']; $i++ ) {
				    $id = null;
				    if ( isset( $options[ 'slider_content_page_'.$i ] ) ) {
				        $id = $options[ 'slider_content_page_'.$i ];
				    }
				    if ( ! empty( $id ) ) {
				        $ids[] = absint( $id );
				    }
				}

				// Bail if no valid pages are selected.
				if ( empty( $ids ) ) {
				    return $input;
				}

				$args = array(
				    'no_found_rows'  => true,
				    'orderby'        => 'post__in',
				    'post_type'      => 'page',
				    'post__in'       => $ids,
				);
			break;

			case 'post':
				$ids = array();

				for ( $i = 1; $i <= $options['slider_content_page_count']; $i++ ) {
				    $id = null;
				    if ( isset( $options[ 'slider_content_post_'.$i ] ) ) {
				        $id = $options[ 'slider_content_post_'.$i ];
				    }
				    if ( ! empty( $id ) ) {
				        $ids[] = absint( $id );
				    }
				}

				// Bail if no valid pages are selected.
				if ( empty( $ids ) ) {
				    return $input;
				}

				$args = array(
				    'no_found_rows'  => true,
				    'orderby'        => 'post__in',
				    'post_type'      => 'post',
				    'post__in'       => $ids,
				);
			break;

			default:
			break;
		}

		if ( in_array( $slider_content_type, array( 'post', 'page' ) ) ) {
			// Fetch posts.
			$posts = get_posts( $args );

			if ( ! empty( $posts ) ) {

			    $i = 1;
			    foreach ( $posts as $key => $post ) {
			        $page_id = $post->ID;
			        $img_array = null;

			        if ( has_post_thumbnail( $page_id ) ) {
							$img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), '' );
						} else {
							$img_array = business_park_dummy_image( 1920, 1080 );
						}

						if ( isset( $img_array ) ) {
							$content[$i]['img_array'] = $img_array;
						}

						$content[$i]['url']              = get_permalink( $page_id );
						$content[$i]['title']            = get_the_title( $page_id );
						$content[$i]['excerpt']          = get_the_excerpt( $page_id );
						$content[$i]['alt']              = get_the_title( $page_id );
						$content[ $i ]['read_more_text'] = $options['slider_content_read_more_text'];

						if ( isset( $options[ 'slider_content_page_icon_'.$i ] ) ) {
							$content[$i]['icon']     = $options[ 'slider_content_page_icon_'.$i ];
						}

			        $i++;
			    }
			}
		}

		if ( ! empty( $content ) ) {
			$input = $content;
		}
		return $input;
	}
endif;
// Slider section content details.
add_filter( 'business_park_filter_slider_section_details', 'business_park_get_slider_section_details' );


if ( ! function_exists( 'business_park_render_slider_section' ) ) :
	/**
	 * Start section class .main-slider
	 *
	 * @return string Slider content
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_render_slider_section( $content_details = array() ) {
		$options = business_park_get_theme_options();

		if ( empty( $content_details ) ) {
			return;
		} ?>

		<section class="main-slider">
		   <div class="cycle-slideshow"
		    	  data-cycle-timeout="2500"
		    	  data-cycle-pause-on-hover="true"
		    	  data-cycle-slides="> figure"
		    	  data-cycle-fx="<?php echo esc_attr( $options["slider_content_effect"] );?>"
		    	  data-cycle-speed="800"
		    	  data-cycle-next="#next"
		    	  data-cycle-prev="#prev">

		    	<?php
		    	$i = 1;
		    	foreach ( $content_details as $content ):
		    	if ( $i == 1 ) {
		    		$display_class = 'display-block';
		    	} else {
		    		$display_class = 'display-none';
		    	}
		    	?>
		    	  	<figure class="<?php echo $display_class; ?>" style="background-image:url('<?php echo esc_url( $content['img_array'][0] ); ?>')">
		    	  		<div class="overlay"></div>
		    	  		<?php if ( $options['enable_slider_captions'] ) { ?>

				         <div class="slider-text">
				             <div class="os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
				             	<?php if ( ! empty( $content['icon'] ) ) { ?>
				                 <img src="<?php echo esc_url( $content['icon'] );?>" class="img-responsve" alt="<?php echo esc_attr( $content['title'] ); ?>">
				             	<?php } ?>
				             </div>
				             <div class="os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
				                 <h1 class="color-white"><?php echo esc_html( $content['title'] ); ?></h1>
				                 <?php if ( ! empty( $content['excerpt'] ) ) {
				                 	echo '<p>' . esc_html( $content['excerpt'] ) . '</p>';
				                 }

				                 if ( ! empty( $content['read_more_text'] ) ) {
				                 	printf( '<a href="%1$s">%2$s</a>', esc_url( $content['url'] ), esc_html( $content['read_more_text'] ) );
				                 }

				                 ?>
				             </div>
				         </div> <!-- /slider-text -->
		    	  		<?php } ?>
		     		</figure>
		    	<?php
		    	$i++;
		    	endforeach; ?>

			   <?php if ( $options['enable_arrow_controls'] ) : ?>
		    		<div class="controls">
			         <div class="cycle-prev"><a href="#" id="prev"><i class="fa fa-angle-left"></i></a></div>
			         <div class="cycle-next"><a href="#" id="next"><i class="fa fa-angle-right"></i></a></div>
			      </div><!--end controls-->
			   <?php endif; ?>
			   <?php if ( $options['enable_slider_pager'] ) : ?>
			   	<div class="cycle-pager"></div>
			   <?php endif; ?>
			   <?php if ( $options['enable_slider_progress_bar'] ) : ?>
			   	<div id="slider-progress"></div>
			   <?php endif; ?>
		   </div><!--end cycle-slideshow-->
		</section>

<?php }
endif;