<?php
/**
 * Team section
 *
 * This is the template for the content of team section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_team_section' ) ) :
    /**
     * Add team section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_team_section() {

        // Check if team is enabled on frontpage
        $team_enable = apply_filters( 'business_park_section_status', true, 'team_enable' );
        if ( true !== $team_enable ) {
            return false;
        }

        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render team section now.
        business_park_render_team_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_team_section', 85 );


if ( ! function_exists( 'business_park_get_team_section_details' ) ) :
    /**
     * Team section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input Team section details.
     */
    function business_park_get_team_section_details( $input ) {
        $options = business_park_get_theme_options();

        // Team type
        $team_content_type    = $options['team_content_type'];

        $content = array();
        switch ( $team_content_type ) {
            case 'demo':
                $name = array( '', 'Jon Doe', 'Zoe Andre', 'Ram Shah', 'Ramsey Nikon' );
                $position = array( '', 'ceo/director', 'Team Lead', 'CTO', 'HR' );
                for ($i=1; $i < 5; $i++) {
                    $content[$i]['img_array'][0] = get_template_directory_uri() . '/assets/uploads/team-0'.$i.'.jpg';
                    $content[$i]['img_array'][1] = 400;
                    $content[$i]['img_array'][2] = 200;
                    $content[$i]['url']      = '#';
                    $content[$i]['position']    = $position[ $i ];
                    $content[$i]['title']    = $name[ $i ];
                    $content[$i]['facebook']  = 'facebook.com';
                    $content[$i]['twitter']  = 'twitter.com';
                    $content[$i]['linkedin']  = 'linkedin.com';
                }
            break;

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['team_content_count']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'team_content_page_'.$i ] ) ) {
                        $id = $options[ 'team_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                );

            break;

            case 'post':
                $ids = array();

                for ( $i = 1; $i <= $options['team_content_count']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'team_content_post_'.$i ] ) ) {
                        $id = $options[ 'team_content_post_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                );

            break;

            default:
            break;
        }
        if ( in_array( $team_content_type, array( 'post', 'page' ) ) ) {
            $posts = get_posts( $args );

            if ( ! empty( $posts ) ) {
                $i = 1;
                foreach ( $posts as $key => $post ) {
                    $post_id = $post->ID;
                    $img_array = null;

                    if ( has_post_thumbnail( $post_id ) ) {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'business-park-pro-team' );
                    } else {
                        $img_array = business_park_dummy_image( 1920, 1080 );
                    }

                    if ( isset( $img_array ) ) {
                        $content[$i]['img_array'] = $img_array;
                    }

                    $content[$i]['url']      = get_permalink( $post_id );
                    $content[$i]['title']    = get_the_title( $post_id );

                    if ( isset( $options[ 'team_position_'.$i ] ) ) {
                        $content[$i]['position']  = $options[ 'team_position_'.$i];
                    }

                    if ( isset( $options[ 'team_facebook_'.$i ] ) ) {
                        $content[$i]['facebook']  = $options[ 'team_facebook_'.$i];
                    }
                    if ( isset( $options[ 'team_twitter_'.$i ] ) ) {
                        $content[$i]['twitter']  = $options[ 'team_twitter_'.$i];
                    }
                    if ( isset( $options[ 'team_linkedin_'.$i ] ) ) {
                        $content[$i]['linkedin']  = $options[ 'team_linkedin_'.$i];
                    }

                    $i++;
                }
            }
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }

        return $input;
    }
endif;
// Team section content details.
add_filter( 'business_park_filter_team_section_details', 'business_park_get_team_section_details' );


if ( ! function_exists( 'business_park_render_team_section' ) ) :
    /**
     * Start section id .about
     *
     * @return string about content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_team_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }

        $section_layout = apply_filters( 'business_park_filter_section_layout', $content_details );
        ?>
        <section id="team">
            <div class="overlay"></div>
            <div class="container">
                <header class="entry-header">
                  <h2 class="entry-title"><?php echo esc_html( $options['team_section_title'] );?></h2>
                </header>
                <div class="entry-content">
                    <?php foreach ( $content_details as $content ):?>
                    <div class="<?php echo esc_attr( $section_layout );?>-col">
                        <div class="team-member">
                            <?php if ( ! empty( $content['img_array'] ) ) { ?>
                                <div class="team-image">
                                    <a href="<?php echo esc_url( $content['url'] );?>">
                                        <img width="<?php echo esc_attr( $content['img_array'][1] );?>" height="<?php echo esc_attr( $content['img_array'][2] );?>" src="<?php echo esc_url( $content['img_array'][0] ); ?>" />
                                    </a>
                                </div><!-- end .team-image -->
                            <?php }?>
                            <div class="team-description">
                                <?php if ( ! empty( $content['position'] ) ) { ?>
                                    <span class="position"><?php echo esc_html( $content['position'] );?></span>
                                <?php }?>
                                <?php if ( ! empty( $content['title'] ) ) { ?>
                                    <h4 class="name"><a href="<?php echo esc_url( $content['url'] );?>"><?php echo esc_html( $content['title'] );?></a></h4>
                                <?php }?>
                            </div><!-- end .team-description -->
                            <ul class="social-icons">
                                <?php if ( ! empty( $content['facebook'] ) ) { ?>
                                    <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['facebook'] );?>" class="icon-hover"></a></li>
                                <?php } ?>
                                <?php if ( ! empty( $content['twitter'] ) ) { ?>
                                    <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['twitter'] );?>" class="icon-hover"></a></li>
                                <?php } ?>
                                <?php if ( ! empty( $content['linkedin'] ) ) { ?>
                                    <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['linkedin'] );?>" class="icon-hover"></a></li>
                                <?php } ?>
                            </ul>
                        </div><!-- end .team-meber -->
                    </div><!-- end .four-col -->
                    <?php endforeach; ?>
                <div class="clear"></div>
                </div><!-- end .entry-content -->
            </div><!-- end .container -->
        </section><!-- end #team -->
<?php
    }
endif;
