<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

if ( ! function_exists( 'business_park_add_testimonial_section' ) ) :
    /**
     * Add testimonial section
     *
     * @since Business Park Pro 2.0.0
     */
    function business_park_add_testimonial_section() {

        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'business_park_section_status', true, 'testimonial_enable' );
        if ( true !== $testimonial_enable ) {
            return false;
        }

        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'business_park_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        business_park_render_testimonial_section( $section_details );
    }
endif;
add_action( 'business_park_primary_content', 'business_park_add_testimonial_section', 10 );


if ( ! function_exists( 'business_park_get_testimonial_section_details' ) ) :
    /**
     * Testimonial section details.
     *
     * @since Business Park Pro 2.0.0
     *
     * @param array $input Testimonial section details.
     */
    function business_park_get_testimonial_section_details( $input ) {
        $options = business_park_get_theme_options();

        // Testimonial type
        $testimonial_content_type    = $options['testimonial_content_type'];

        $content = array();
        switch ( $testimonial_content_type ) {
            case 'demo':
                for ( $i=0; $i < 3; $i++ ) {
                    $content[ $i ]['img_html'] = '<img src="' . get_template_directory_uri() . '/assets/uploads/author_01.jpg' .'">';
                    $content[ $i ]['url']      = '#';
                    $content[ $i ]['title']    = esc_html__( 'THEODORE GIOVANNI', 'business-park-pro' );
                    $content[ $i ]['content']  = esc_html__( 'Quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.', 'business-park-pro' );
                    $content[ $i ]['facebook'] = 'facebook.com';
                    $content[ $i ]['twitter']  = 'twitter.com';
                    $content[ $i ]['pinterest']= 'pinterest.com';
                }
            break;

            case 'testimonial':
                $ids = array();

                for ( $i = 1; $i <= $options['testimonial_content_count']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'testimonial_content_'.$i ] ) ) {
                        $id = $options[ 'testimonial_content_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'jetpack-testimonial',
                    'post__in'       => $ids,
                );

            break;

            case 'category':
                if ( isset( $options[ 'testimonial_content_category' ] ) ) {
                    $cat_id = $options[ 'testimonial_content_category' ];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'category'       => absint( $cat_id ),
                    'posts_per_page' => absint( $options['testimonial_content_count'] )
                );

            break;

            default:
            break;
        }
        if ( 'demo' != $testimonial_content_type ) {
            // Fetch posts.
            $posts = get_posts( $args );

            if ( ! empty( $posts ) ) {

                $i = 1;
                foreach ( $posts as $key => $post ) {
                    $page_id = $post->ID;
                    if ( has_post_thumbnail( $page_id ) ) {
                        $img_html = get_the_post_thumbnail( $page_id, '', array( 'alt' => the_title_attribute( 'echo=0&post='.$page_id.'' ) ) );

                        $content[$i]['img_html'] = $img_html;
                    }

                    if ( isset( $img_array ) ) {
                        $content[$i]['img_array'] = $img_array;
                    }

                    $content[$i]['url']      = get_permalink( $page_id );
                    $content[$i]['title']    = get_the_title( $page_id );
                    $content[$i]['content']  = business_park_trim_content( $post );

                    if ( isset( $options[ 'testimonial_facebook_'.$i ] ) ) {
                        $content[$i]['facebook']  = $options[ 'testimonial_facebook_'.$i];
                    }
                    if ( isset( $options[ 'testimonial_twitter_'.$i ] ) ) {
                        $content[$i]['twitter']  = $options[ 'testimonial_twitter_'.$i];
                    }
                    if ( isset( $options[ 'testimonial_pinterest_'.$i ] ) ) {
                        $content[$i]['pinterest']  = $options[ 'testimonial_pinterest_'.$i];
                    }

                    $i++;
                }
            }
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;

    }
endif;
// Testimonial section content details.
add_filter( 'business_park_filter_testimonial_section_details', 'business_park_get_testimonial_section_details' );


if ( ! function_exists( 'business_park_render_testimonial_section' ) ) :
    /**
     * Start section id .client-carousel
     *
     * @return string testimonial content
     * @since Business Park Pro 2.0.0
     *
     */
    function business_park_render_testimonial_section( $content_details = array() ) {
        $options = business_park_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <section id="client-carousel">
            <div class="overlay"></div><!-- end overlay -->
            <?php
            if ( 'video' == $options['testimonial_background_type'] ) {
                $testimonial_bg_video = $options['testimonial_bg_video'];
                if ( ! empty( $testimonial_bg_video ) ) {
                    $testimonial_bg_video_url = wp_get_attachment_url( absint( $testimonial_bg_video ) );
                    ?>
                    <video autoplay loop>
                       <source src="<?php echo esc_url( $testimonial_bg_video_url );?>" type="video/mp4">
                   </video>
                <?php
                }
            }
            ?>
            <div class="container">
                <?php if ( ! empty( $options['testimonial_title'] ) ) : ?>
                    <header class="entry-header">
                        <h2 class="entry-title"><?php echo esc_html( $options['testimonial_title'] );?></h2>
                    </header>
                <?php endif; ?>
                <div class="entry-content">
                    <div id="client-testimonial"
                        class="cycle-slideshow os-animation"
                        data-os-animation="fadeIn"
                        data-os-animation-delay="0.3s"
                        data-os-animation-duration="2s"
                        data-cycle-pause-on-hover="true"
                        data-cycle-timeout="2500"
                        data-cycle-pager=".testimonial-cycle-pager"
                        data-cycle-slides="> figure"
                        data-cycle-fx="scrollHorz"
                        data-cycle-speed="1200"
                        data-cycle-pager=".cycle-pager">
                        <?php foreach ( $content_details as $content ): ?>
                            <figure>
                                <?php
                                $class = '';
                                if ( empty( $content['img_html'] ) ) {
                                    $class = 'no-client-image';
                                } ?>
                                <div class="client-content <?php echo $class;?>">
                                    <div class="client-detail-wrap clear">
                                        <?php if ( ! empty( $content['img_html'] ) ) { ?>
                                            <div class="client-image">
                                                <a href="<?php echo esc_url( $content['url'] );?>"><?php echo $content['img_html'];?></a>
                                            </div><!-- end client image-->
                                        <?php } ?>
                                        <div class="client-name">
                                            <a href="<?php echo esc_url( $content['url'] );?>"><span><?php echo esc_html( $content['title'] );?></span></a>
                                        </div><!-- end client-name -->
                                        <p><?php echo esc_html( $content['content'] );?></p>

                                    </div><!-- end .client-detail-wrap -->

                                    <ul class="list-inline social-icons">
                                        <?php if ( ! empty( $content['facebook'] ) ) { ?>
                                            <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['facebook'] );?>" class="icon-hover"></a></li>
                                        <?php } ?>
                                        <?php if ( ! empty( $content['twitter'] ) ) { ?>
                                            <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['twitter'] );?>" class="icon-hover"></a></li>
                                        <?php } ?>
                                        <?php if ( ! empty( $content['pinterest'] ) ) { ?>
                                            <li class="icon-animation icon-hover-effect"><a href="<?php echo esc_url( $content['pinterest'] );?>" class="icon-hover"></a></li>
                                        <?php } ?>
                                    </ul><!--end social-icons -->
                                </div><!--end client-content -->

                                <div class="clear"></div>
                            </figure>
                            <div class="clear"></div>
                        <?php endforeach;?>
                    </div><!-- end cycle-slideshow -->
                    <div class="testimonial-cycle-pager"></div><!-- end cycle-pager -->
                </div><!-- end entry-content -->
            </div><!-- end container -->
        </section>
<?php
    }
endif;