<?php
/**
 * Business Park basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

$options = business_park_get_theme_options();


if ( ! function_exists( 'business_park_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since Business Park Pro 2.0.0
	 */
	function business_park_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>><?php
	}
endif;

add_action( 'business_park_doctype', 'business_park_doctype', 10 );


if ( ! function_exists( 'business_park_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif; ?>
		<?php
	}
endif;
add_action( 'business_park_before_wp_head', 'business_park_head', 10 );


if ( ! function_exists( 'business_park_page_start' ) ) :
	/**
	 * Start div id #page and screen reader link
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_page_start() {
		?>
		<div id="page" class="hfeed site">
			<div class="site-inner">
				<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'business-park-pro' ); ?></a>
		<?php
	}
endif;
add_action( 'business_park_page_start', 'business_park_page_start', 10 );


if ( ! function_exists( 'business_park_loader' ) ) :
	/**
	 * Start div id #loader
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_loader() {
		$options = business_park_get_theme_options();
		$loader_url = $options['loader_gif'];
		if ( $options['loader_enable'] ) { ?>
			<div id="loader">
	         <div class="loader-container">
	         	<?php if ( 'icon' == $options['loader_type'] ) { ?>
	         		<i class="fa <?php echo esc_attr( $options['loader_icon'] );?> fa-spin"></i>
	         	<?php } else { ?>
	            	<img class="fa-spin" src="<?php echo esc_url( $loader_url ); ?>" alt="<?php esc_attr_e( 'Loader', 'business-park-pro' );?>" />
	         	<?php } ?>
	         </div>
	     	</div><!-- end loader -->
		<?php }
	}
endif;
add_action( 'business_park_before_header', 'business_park_loader', 10 );


if ( ! function_exists( 'business_park_top_bar' ) ) :
	/**
	 * Start div class .top-bar
	 *
	 * @since Business Park Pro 2.0.1
	 *
	 */
	function business_park_top_bar() {
		$options = business_park_get_theme_options();
		?>
		<!-- Top bar -->
     	<div class="top-bar align-left"><!-- use align-right class to change position-->
     		<div class="topbar-dropdown-toggle"><i class="fa fa-angle-down"></i></div>
     		<div class="container">
		     	<ul class="address">
		     		<?php if ( $options['top_bar_phone'] ) { ?>
						<li><a href="tel:<?php echo esc_html( $options['top_bar_phone'] );?>"><i class="fa fa-phone "></i><?php echo esc_html( $options['top_bar_phone'] );?></a></li>
		     		<?php }  
		     		if ( $options['top_bar_email'] ) { ?>
						<li><a href="mailto:<?php echo esc_html( $options['top_bar_email'] );?>"><i class="fa fa-envelope "></i><?php echo sanitize_email( $options['top_bar_email'] );?></a></li>
		     		<?php }  
		     		if ( $options['top_bar_location'] ) { ?>
						<li><i class="fa fa-map-marker"></i><?php echo esc_textarea( $options['top_bar_location'] );?></li>
		     		<?php } ?>
				</ul><!-- end .address -->
			<?php if ( has_nav_menu( 'jetpack-social-menu' ) ) {
	     		/**
				* Displays social navigation menu
				* @param array $args Arguments
				*/
			
				wp_nav_menu( 
					array(
						'theme_location'  => 'jetpack-social-menu',
						'container'       => 'div',
						'container_class' => 'social-icons',
						'menu_class'      => 'list-inline color-grey',
						'items_wrap'      => '<ul id = "%1$s" class = "%2$s">%3$s</ul>',
						'depth'           => 1,
						)
					);
				
			}
			?>
			</div><!-- end .container -->
     	</div> <!-- /top-bar -->
		<?php
	}
endif;
add_action( 'business_park_before_header', 'business_park_top_bar', 20 );


if ( ! function_exists( 'business_park_header_start' ) ) :
	/**
	 * Start div id #masthead
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_header_start() {
		$options = business_park_get_theme_options();
		$sticky_class = '';
		if ( $options['primary_menu_sticky_enable'] ) {
			$sticky_class = 'make-sticky';
		}
		?>
		<header id="masthead" class="site-header <?php echo esc_attr( $sticky_class );?>" role="banner">
			<div class="container">
		<?php
	}
endif;
if ( 'top' == $options['primary_menu_position'] ) {
	add_action( 'business_park_before_header', 'business_park_header_start', 25 );
} else {
	add_action( 'business_park_header', 'business_park_header_start', 10 );
}

if ( ! function_exists( 'business_park_site_branding' ) ) :
	/**
	 * Start .site-branding
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_site_branding() {
		get_template_part( 'components/header/site', 'branding' );
	}
endif;
if ( 'top' == $options['primary_menu_position'] ) {
	add_action( 'business_park_before_header', 'business_park_site_branding', 25 );
} else {
	add_action( 'business_park_header', 'business_park_site_branding', 20 );
}

if ( ! function_exists( 'business_park_site_nav' ) ) :
	/**
	 * Site navigation
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_site_nav() {
		get_template_part( 'components/navigation/navigation', 'top' );
	}
endif;
if ( 'top' == $options['primary_menu_position'] ) {
	add_action( 'business_park_before_header', 'business_park_site_nav', 25 );
} else {
	add_action( 'business_park_header', 'business_park_site_nav', 30 );
}


if ( ! function_exists( 'business_park_site_nav_search' ) ) :
	/**
	 * Site navigation search icon
	 *
	 * @since Business Park Pro 2.0.1
	 *
	 */
	function business_park_site_nav_search( $items, $args ) {
		$search = '';
		if ( 'primary-menu' == $args->menu_id ) {
			// Search Box
			$options = business_park_get_theme_options();
			$enable_search = $options['primary_menu_search_icon'];
			if ( $enable_search ) {
			   $search = '<li>
							   <div class="search-btn">
							   	<i id="show-search" class="fa fa-search"></i>
							   </div>

							  </li>';
			}
		}
		return $items . $search;
	}
endif;
add_filter('wp_nav_menu_items','business_park_site_nav_search', 10, 2);


if ( ! function_exists( 'business_park_header_end' ) ) :
	/**
	 * Header ends
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_header_end() { ?>
			</div><!-- .header-wrap -->
		</header>
	<?php
	}
endif;
if ( 'top' == $options['primary_menu_position'] ) {
	add_action( 'business_park_before_header', 'business_park_header_end', 25 );
} else {
	add_action( 'business_park_header', 'business_park_header_end', 100 );
}


if ( ! function_exists( 'business_park_content_start' ) ) :
	/**
	 * Start div id #content
	 *
	 * Site content starts
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_content_start() { ?>
		<div id="content" class="site-content">
	<?php
	}
endif;
add_action( 'business_park_content_start', 'business_park_content_start', 10 );


if ( ! function_exists( 'business_park_content_end' ) ) :
	/**
	 * End div id #content
	 *
	 * Site content ends
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_content_end() { ?>
		</div><!-- end #content-->
	<?php
	}
endif;
add_action( 'business_park_content_end', 'business_park_content_end', 100 );


if ( ! function_exists( 'business_park_scroll_top' ) ) :
	/**
	 * Start div class .backtotop
	 *
	 * Scroll to top
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_scroll_top() { ?>
		<div class="backtotop fa fa-angle-up"></div>
	<?php
	}
endif;
add_action( 'business_park_scroll_top', 'business_park_scroll_top', 10 );


if ( ! function_exists( 'business_park_footer_start' ) ) :
	/**
	 * Start footer id .colophon
	 *
	 * Footer start
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_footer_start() {
		?>
		<footer id="colophon" class="bg-green site-footer">
		    <div class="container">
		<?php
	}
endif;
add_action( 'business_park_footer', 'business_park_footer_start', 10 );


if ( ! function_exists( 'business_park_footer_logo' ) ) :
	/**
	 * Start div class .footer-logo
	 *
	 * Footer start
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_footer_logo() {
		$options = business_park_get_theme_options();
		if ( $options['footer_logo_enable'] ) { ?>
			<div class="footer-logo os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
				<a href="<?php esc_url( home_url( '/' ) );?>">
	         	<img src="<?php echo esc_url( $options['footer_logo'] );?>" alt="<?php esc_attr_e( 'Footer Logo', 'business-park-pro' );?>">
	      	</a>
	      </div>
		<?php }
	}
endif;
add_action( 'business_park_footer', 'business_park_footer_logo', 20 );


if ( ! function_exists( 'business_park_footer' ) ) :
	/**
	 * Footer
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_footer() {
		$footer_sidebar_data = business_park_footer_sidebar_class();
		$active_id           = $footer_sidebar_data['active_id'];
		$class               = $footer_sidebar_data['class'];

		if ( empty( $active_id ) ) {
			return;
		} ?>

      <div class="footer-layout">
      	<?php
      	for ( $i=0; $i < count( $active_id ); $i++ ) { ?>
          <div class="<?php echo esc_attr( $class );?>-col os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
      			<?php
      			if ( is_active_sidebar( 'footer-'.absint( $active_id[ $i ] ).'' ) ){
      				dynamic_sidebar( 'footer-'.absint( $active_id[ $i ] ).'' );
      			}
      			?>
          </div><!--end col-->
      	<?php }?>
          <div class="clear"></div>
      </div><!--end footer-layout -->
		<?php
	}
endif;
add_action( 'business_park_footer', 'business_park_footer', 30 );


if ( ! function_exists( 'business_park_copyright' ) ) :
	/**
	 * Start div class .site-info
	 *
	 * Footer site info
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_copyright() {
		get_template_part( 'components/footer/site', 'info' );
	}
endif;
add_action( 'business_park_footer', 'business_park_copyright', 90 );


if ( ! function_exists( 'business_park_footer_end' ) ) :
	/**
	 * End div .site-info
	 *
	 * Footer end
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_footer_end() {
		?>
		    </div><!--end .container-->
		</footer>
		<?php
	}
endif;
add_action( 'business_park_footer', 'business_park_footer_end', 100 );


if ( ! function_exists( 'business_park_page_end' ) ) :
	/**
	 * End div id #content
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 */
	function business_park_page_end() {
		?>
				</div><!--end site-inner -->
		</div><!-- end site-->
		<?php
	}
endif;
add_action( 'business_park_page_end', 'business_park_page_end', 100 );