<?php
/**
 * Business park widgets inclusion
 *
 * This is the template that includes all custom widgets of Business Park
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


/**
 * Add social link widget
 */
require get_template_directory() . '/inc/widgets/social-link.php';

/**
 * Add contact info widget
 */
require get_template_directory() . '/inc/widgets/contact-info.php';

/**
 * Register widgets
 */
add_action( 'widgets_init', function() {
   register_widget( 'Business_Park_Social_Link' );

   // Add fontawesome
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/plugins/fontawesome/css/font-awesome.min.css', '', '4.6.3' );

	// Add custom css for customizer
	wp_enqueue_style( 'business-park-customizer', get_template_directory_uri() . '/assets/css/customizer.min.css' );
   register_widget( 'Business_Park_Custom_Info_Widget' );
});
