<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header(); 

/**
 * personify_pro_simple_breadcrumb_action hook
 *
 * @hooked personify_pro_add_breadcrumb -  10
 *
 */
do_action( 'personify_pro_simple_breadcrumb_action' );
?>

<div id="page-title" class="relative">
    <div class="wrapper">
        <header class="page-header">
            <?php
			if ( false === $options['title_break'] ) :
				the_archive_title( '<h1 class="entry-title">', '</h1>' );
			else :
				$title = explode( ' ', get_the_archive_title() );
				$first_word = $title[0];
				$title = implode( ' ', array_slice( $title, 1 ) );
				?>
				<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo wp_kses_post( $title ); ?></h2>
			<?php endif; ?>
        </header>
    </div><!-- .wrapper -->
</div><!-- #page-title -->

<div class="wrapper page-section no-padding-top">       
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="blog-posts-wrapper">
				<?php
				if ( have_posts() ) : 
					$i = 1;
					$int = 0;
					/* Start the Loop */
					while ( have_posts() ) : the_post();
						if ( has_post_thumbnail() ) $int = 0;

						/**
						* Hook - personify_pro_get_content_action.
						*
						* @hooked personify_pro_get_content 
						*/
						do_action( 'personify_pro_get_content_action', $i, $int );
						
						$i++;
						$int++;
					endwhile;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; 
				?>
			</div><!-- .blog-posts-wrapper -->
			<?php
			/**
			* Hook - personify_pro_action_pagination.
			*
			* @hooked personify_pro_pagination 
			*/
			do_action( 'personify_pro_action_pagination' ); 

			/**
			* Hook - personify_pro_infinite_loader_spinner_action.
			*
			* @hooked personify_pro_infinite_loader_spinner 
			*/
			do_action( 'personify_pro_infinite_loader_spinner_action' );
			?>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrapper -->
<?php
get_footer();
