<?php
/**
 * Template Name: Contact Template
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header(); 
$options = personify_pro_get_theme_options(); 

/**
 * personify_pro_simple_breadcrumb_action hook
 *
 * @hooked personify_pro_add_breadcrumb -  10
 *
 */
do_action( 'personify_pro_simple_breadcrumb_action' );
?>
<div id="page-title" class="relative">
    <div class="wrapper">
        <header class="page-header">
        
			<?php
			if ( false === $options['title_break'] ) :
				the_title( '<h2 class="entry-title">', '</h2>' );
			else :
				$title = explode( ' ', get_the_title() );
				$first_word = $title[0];
				$title = implode( ' ', array_slice( $title, 1 ) );
				?>
				<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
			<?php endif; ?>

		</header><!-- .entry-header -->
    </div><!-- .wrapper -->
</div><!-- #page-title -->

<div id="contact-address" class="relative page-section">
    <div class="wrapper">
        <div class="section-content <?php echo ( ! empty( $options['map_content_embed'] ) || ! empty( $options['map_content_shortcode'] ) ) ? 'col-2' : 'col-1'; ?>">
            <?php  
			/**
			 * personify_pro_contact_details_action hook
			 *
			 * @hooked personify_pro_contact_details - 10
			 * @hooked personify_pro_contact_map - 20
			 *
			 */
			do_action( 'personify_pro_contact_details_action' );
			?>
        </div><!-- .section-content -->
    </div><!-- .wrapper -->
</div><!-- #contact-address -->

<?php  
/**
 * personify_pro_contact_form_action hook
 *
 * @hooked personify_pro_contact_form - 10
 *
 */
do_action( 'personify_pro_contact_form_action' );

get_footer();
