<?php
/**
 * About Career section
 *
 * This is the template for the content of career section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_career_section' ) ) :
    /**
    * Add career section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_career_section() {
        $options = personify_pro_get_theme_options();

        // Check if career is enabled on frontpage
        $career_enable = $options['career_section_enable'];

        if ( true !== $career_enable ) {
            return false;
        }
        // Get career section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_career_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render career section now.
        personify_pro_render_career_section( $section_details );
    }
endif;
add_action( 'personify_pro_about_template_content', 'personify_pro_add_career_section', 10 );


if ( ! function_exists( 'personify_pro_get_career_section_details' ) ) :
    /**
    * career section details.
    *
    * @since Personify Pro 1.0
    * @param array $input career section details.
    */
    function personify_pro_get_career_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $career_content_type  = $options['career_content_type'];
        $content = array();
        switch ( $career_content_type ) {
            case 'demo':
                $demo['title']      =  esc_html__( 'My Career', 'personify-pro' );
                $demo['excerpt']    = sprintf( '<p> %1$s </p> <p> %2$s </p>', esc_html__( 'Quisque sodales purus sit amet libero pellentesque cursus. Sed blandit nisl purus, ac rutrum risus bibendum interdum. Quisque tincidunt sapien non lorem rhoncus euismod. Nullam hendrerit dapibus volutpat. Nunc at egestas eros. Cras ultrices libero lorem. Mauris hendrerit ut lectus id pellentesque. Nam rutrum condimentum rutrum. Nulla id ante nibh. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.', 'personify-pro' ), esc_html__( 'Mauris hendrerit ut lectus id pellentesque. Nam rutrum condimentum rutrum. Nulla id ante nibh. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.', 'personify-pro' ) );

                // Push to the main array.
                array_push( $content, $demo );
            break;

            case 'custom':
                $custom['title']        = ! empty( $options['career_title'] ) ? $options['career_title'] : '';
                $custom['excerpt']      = ! empty( $options['career_description'] ) ? wpautop( $options['career_description'] ) : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['career_content_page'] ) ? $options['career_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['career_content_post'] ) ? $options['career_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( 'post' === $career_content_type || 'page' === $career_content_type ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = wpautop( get_the_content() );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// career section content details.
add_filter( 'personify_pro_filter_career_section_details', 'personify_pro_get_career_section_details' );


if ( ! function_exists( 'personify_pro_render_career_section' ) ) :
  /**
   * Start career section
   *
   * @return string career content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_career_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();
        $skill_shortcode = ! empty( $options['skill_shortcode'] ) ? $options['skill_shortcode'] : '';
        $col_class = ( true === $options['skill_section_enable'] && ! empty( $skill_shortcode ) ) ? 'col-2' : 'col-1';
        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) : ?>
            <div id="skills-section" class="relative page-section">
                <div class="wrapper">
                    <div class="section-content <?php echo esc_attr( $col_class ); ?>">
                        <div class="column-wrapper">
                            <article class="hentry">
                                <?php if ( ! empty( $content['title'] ) ) : ?>
                                    <header class="entry-header">
                                        <?php  
                                        $title = explode( ' ', $content['title'] );
                                        $first_word = $title[0];
                                        $title = implode( ' ', array_slice( $title, 1 ) );
                                        ?>
                                        <h2 class="entry-title"><small><?php echo esc_html( $first_word ) ?></small> <?php echo esc_html( $title ); ?></h2>
                                    </header>
                                <?php endif; 

                                if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                       <?php echo wp_kses_post( $content['excerpt'] ); ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>
                            </article>
                        </div><!-- .column-wrapper -->
                        
                        <?php if ( true === $options['skill_section_enable'] && ! empty( $skill_shortcode ) ) : ?>
                            <div class="column-wrapper">
                                <div class="skills-wrapper">
                                    <?php echo do_shortcode( wp_kses_post( $skill_shortcode ) ); ?>
                                </div><!-- .skills-wrapper -->
                            </div><!-- .column-wrapper -->
                        <?php endif; ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #skills-section -->
        <?php endforeach;
    }
endif;