<?php
/**
 * About Portfolio section
 *
 * This is the template for the content of portfolio section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */
if ( ! function_exists( 'personify_pro_add_portfolio_section' ) ) :
    /**
    * Add portfolio section
    *
    *@since Personify Pro 1.0
    */
    function personify_pro_add_portfolio_section() {
        $options = personify_pro_get_theme_options();

        // Check if portfolio is enabled on frontpage
        $portfolio_enable = $options['portfolio_section_enable'];

        if ( true !== $portfolio_enable ) {
            return false;
        }
        // Get portfolio section details
        $section_details = array();
        $section_details = apply_filters( 'personify_pro_filter_portfolio_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render portfolio section now.
        personify_pro_render_portfolio_section( $section_details );
    }
endif;
add_action( 'personify_pro_about_template_content', 'personify_pro_add_portfolio_section', 20 );


if ( ! function_exists( 'personify_pro_get_portfolio_section_details' ) ) :
    /**
    * portfolio section details.
    *
    * @since Personify Pro 1.0
    * @param array $input portfolio section details.
    */
    function personify_pro_get_portfolio_section_details( $input ) {
        $options = personify_pro_get_theme_options();

        // Content type.
        $portfolio_note_content_type    = $options['portfolio_note_content_type'];
        $portfolio_content_type         = $options['portfolio_content_type'];
        $portfolio_count  = ! empty( $options['portfolio_count'] ) ? $options['portfolio_count'] : 4;
        $content = array();
        $content['note'] = array();
        $content['portfolio'] = array();

        switch ( $portfolio_note_content_type ) {
            case 'demo':
                $demo['note']['title']      = esc_html__( 'My Movies', 'personify-pro' );
                $demo['note']['excerpt']    = esc_html__( 'Sed id lorem semper, iaculis ligula a, bibendum tortor. Cras non tempor mauris.Curabitur tristique magna vitae lorem venenatis, eu laoreet nisl ultricies. Phasellus lacinia vehicula tincidunt.', 'personify-pro' );

                // Push to the main array.
                array_push( $content['note'], $demo['note'] );
            break;

            case 'custom':
                $custom['note']['title']        = ! empty( $options['portfolio_note_title'] ) ? $options['portfolio_note_title'] : '';
                $custom['note']['excerpt']      = ! empty( $options['portfolio_note_description'] ) ? $options['portfolio_note_description'] : '';

                // Push to the main array.
                array_push( $content['note'], $custom['note'] );
            break;

            case 'page':
                $page_id = ! empty( $options['portfolio_note_content_page'] ) ? $options['portfolio_note_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['portfolio_note_content_post'] ) ? $options['portfolio_note_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( in_array( $portfolio_note_content_type, array( 'page', 'post' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['note']['title']     = get_the_title();
                    $page_post['note']['excerpt']   = get_the_content();

                    // Push to the main array.
                    array_push( $content['note'], $page_post['note'] );
                endwhile;
            endif;
            wp_reset_postdata();

        }

        switch ( $portfolio_content_type ) {
            case 'demo':
                for ( $i = 1; $i <= 4; $i++ ) {
                    $int = ( $i === 4 ) ? $i - 2 : $i;
                    $demo['portfolio']['title'] = esc_html__( 'Movies', 'personify-pro' );
                    $demo['portfolio']['url']   = '#';
                    $demo['portfolio']['image'] = get_template_directory_uri() . '/assets/uploads/portfolio-0' . $int . '.jpg';

                    // Push to the main array.
                    array_push( $content['portfolio'], $demo['portfolio'] );
                }
            break;

            case 'category':
                $cat_id = ! empty( $options['portfolio_content_category'] ) ? $options['portfolio_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'cat'               => absint( $cat_id ),
                    'posts_per_page'    => absint( $portfolio_count ),
                    ); 
            break;

            case 'page':
                $page_id = array();

                for ( $i = 1; $i <= $portfolio_count; $i++ ) {
                    if ( ! empty( $options['portfolio_content_page_' . $i] ) ) :
                        $page_id[]  = $options['portfolio_content_page_' . $i];
                    endif;
                }
                $args = array(
                    'post_type'         => 'page',
                    'orderby'           => 'post__in',
                    'post__in'          => $page_id,
                    'posts_per_page'    => count( $page_id ),
                    );              
            break;

            case 'post':
                $post_id = ! empty( $options['portfolio_content_post'] ) ? $options['portfolio_content_post'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'orderby'               => 'post__in',
                    'post__in'              => $post_id,
                    'posts_per_page'        => count( $post_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }

        if (  in_array( $portfolio_content_type, array( 'post', 'page', 'category' ) ) ) {

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['portfolio']['title']     = get_the_title();
                    $page_post['portfolio']['url']       = get_the_permalink();
                    if ( has_post_thumbnail() ) :
                        $page_post['portfolio']['image']     = get_the_post_thumbnail_url( '', 'post-thumbnail' );
                    else :
                        $page_post['portfolio']['image'] = get_template_directory_uri() . '/assets/uploads/no-featured-image-295x400.jpg';
                    endif;

                    // Push to the main array.
                    array_push( $content['portfolio'], $page_post['portfolio'] );
                endwhile;
            endif;
            wp_reset_postdata();

        }

    if ( ! empty( $content ) ) {
        $input = $content;
    }
    return $input;
    }
endif;
// portfolio section content details.
add_filter( 'personify_pro_filter_portfolio_section_details', 'personify_pro_get_portfolio_section_details' );


if ( ! function_exists( 'personify_pro_render_portfolio_section' ) ) :
  /**
   * Start portfolio section
   *
   * @return string portfolio content
   * @since Personify Pro 1.0
   *
   */
   function personify_pro_render_portfolio_section( $content_details = array() ) {
        $options = personify_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="movies-list" class="relative page-section">
            <div class="wrapper">
                <div class="section-content col-2">
                    <?php foreach ( $content_details['note'] as $content ) : ?>
                        <div class="column-wrapper entry-container">
                            <article class="hentry">
                                <?php if ( ! empty( $content['title'] ) ) : ?>
                                    <header class="entry-header">
                                        <?php  
                                            $title = explode( ' ', $content['title'] );
                                            $first_word = $title[0];
                                            $title = implode( ' ', array_slice( $title, 1 ) );
                                        ?>
                                        <h2 class="entry-title"><small><?php echo esc_html( $first_word ); ?></small> <?php echo esc_html( $title ); ?></h2>
                                    </header>
                                <?php endif; 

                                if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                        <?php echo wp_kses_post( $content['excerpt'] ); ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>
                            </article>
                        </div><!-- .column-wrapper -->
                    <?php endforeach; ?>

                    <div class="column-wrapper">
                        <span class="pagingInfo"></span>
                        <div class="movies-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 700, "dots": false, "arrows":true, "autoplay": true, "fade": false, "draggable": true }'>
                            <?php foreach ( $content_details['portfolio'] as $content ) : ?>
                                <article class="slick-item <?php echo ( empty( $content['image'] ) ) ? 'no-featured-image' : ''; ?>">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>">
                                        <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                        <h3><?php echo esc_html( $content['title'] ); ?></h3>
                                    </a>
                                </article>
                            <?php endforeach; ?>
                        </div><!-- .movies-slider -->
                    </div><!-- .column-wrapper -->

                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #movies-list -->
    <?php }
endif;