<?php 
/**
 * Contact Detail section
 *
 * This is the template for the content of contact detail section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

if ( ! function_exists( 'personify_pro_contact_details' ) ) :
    /**
    * Add map section
    *
    *@since Personify Pro 1.0
    */
	function personify_pro_contact_details() {
		$options = personify_pro_get_theme_options();
		?>
		<div class="column-wrapper custom-info">
            <div id="custom_info_widget-1" class="widget widget_call_to_action">  
            	<?php if ( ! empty( $options['contact_detail_title'] ) ) : ?> 
                	<h2 class="widget-title"><?php echo esc_html( $options['contact_detail_title'] ); ?></h2>
                <?php endif; ?> 
                <ul>
                	<?php if ( ! empty( $options['contact_address'] ) ) : ?>
                        <li>
                        	<?php echo personify_pro_get_svg( array( 'icon' => 'flag' ) ); ?>
                            <span class="address"><?php echo esc_html( $options['contact_address'] ); ?></span>
                        </li>
                    <?php endif; 

                    if ( ! empty( $options['contact_phone'] ) ) : ?>
                        <li>
                        	<?php echo personify_pro_get_svg( array( 'icon' => 'phone' ) ); ?>
                            <span class="phone"><?php echo esc_html( $options['contact_phone'] ); ?></span>
                        </li>
                    <?php endif;

                    if ( ! empty( $options['contact_email'] ) ) : ?>
                    <li>
                    	<?php echo personify_pro_get_svg( array( 'icon' => 'envelope' ) ); ?>
                        <span class="email"><?php echo esc_html( $options['contact_email'] ); ?></span>
                    </li>
                	<?php endif; ?>
            	</ul>
            </div>
        </div><!-- .column-wrapper -->
	<?php
	}
endif;
add_action( 'personify_pro_contact_details_action', 'personify_pro_contact_details', 10 );

if ( ! function_exists( 'personify_pro_contact_map' ) ) :
    /**
    * Add map section
    *
    *@since Personify Pro 1.0
    */
	function personify_pro_contact_map() {
		$options = personify_pro_get_theme_options();
		$map_content_embed      = ! empty( $options['map_content_embed'] ) ? $options['map_content_embed'] : '';
	    $map_content_shortcode  = ! empty( $options['map_content_shortcode'] ) ? $options['map_content_shortcode'] : '';

	    if ( 'shortcode' === $options['map_content_type'] ) {
	    	if ( empty( $map_content_shortcode ) )
	    		return false;
	    }
    	elseif ( 'embed' === $options['map_content_type'] ) {
    		if ( empty( $map_content_embed ) )
    			return false;
    	}
		?>
		<div class="column-wrapper map-column">
			<div id="map">
		        <?php 
		        if ( $options['map_content_type'] == 'shortcode' ){
		            echo do_shortcode( wp_kses_post( $map_content_shortcode ) );
		        } elseif ( $options['map_content_type'] == 'embed'  ) {
		            echo personify_pro_santize_iframe_map( $map_content_embed );
		        }
		        ?>
		        </div><!-- #map -->
	    </div><!-- .column-wrapper -->
	<?php
	}
endif;
add_action( 'personify_pro_contact_details_action', 'personify_pro_contact_map', 20 );

if ( ! function_exists( 'personify_pro_contact_form' ) ) :
    /**
    * Add contact form section
    *
    *@since Personify Pro 1.0
    */
	function personify_pro_contact_form() {
		$options = personify_pro_get_theme_options();

		if ( empty( $options['form_content_shortcode'] ) ) {
			return;
		}
		?>
		<div id="contact-form" class="relative page-section no-padding-top">
		    <div class="wrapper">
		        <div class="section-content">
		            
		            <?php if ( ! empty( $options['contact_form_title'] ) ) : ?>
                        <header class="entry-header">
                            <?php  
                                $title = explode( ' ', $options['contact_form_title'] );
                                $first_word = $title[0];
                                $title = implode( ' ', array_slice( $title, 1 ) );
                            ?>
                            <h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
                        </header>
                    <?php endif;

                    echo do_shortcode( wp_kses_post( $options['form_content_shortcode'] ) ); ?>
		            
		        </div><!-- .section-content -->
		    </div><!-- .wrapper -->
		</div><!-- #contact-form -->
	<?php
	}
endif;
add_action( 'personify_pro_contact_form_action', 'personify_pro_contact_form', 10 );