<?php 
/**
 * Event Content
 *
 * This is the template for the content of contact detail section
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

if ( ! function_exists( 'personify_pro_event_page_content' ) ) :
    /**
    * Add event page
    *
    *@since Personify Pro 1.0
    */
	function personify_pro_event_page_content() {
		$options = personify_pro_get_theme_options();
        $category = ! empty( $options['event_page_category'] ) ? $options['event_page_category'] : '';
        $event_count = ! empty( $options['event_page_count'] ) ? $options['event_page_count'] : 5;

        $args = array(  
            'post_type'             => 'post',
            'cat'                   => absint( $category ),
            'ignore_sticky_posts'   => true,
            'posts_per_page'        => absint( $event_count ),
            );
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post();
		?>
    		<article id="post-01" class="hentry">
                <?php if ( has_post_thumbnail() ) : ?>
                    <div class="featured-image">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail( 'thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); ?>
                            <div class="red-overlay"></div>
                            <?php echo personify_pro_get_svg( array( 'icon' => 'add' ) ); ?>
                        </a>
                    </div><!-- .featured-image -->
                <?php endif; ?>
                <div class="entry-summary">
                    <time>
                        <span><?php echo date_i18n( 'd',  strtotime( get_the_date() ) ); ?></span>
                        <?php echo date_i18n( 'M, Y',  strtotime( get_the_date() ) ); ?>
                    </time>
                    <header class="entry-header">
                        <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                    </header>

                    <div class="entry-content">
                        <?php echo personify_pro_trim_content( 20 ); ?>
                    </div><!-- .entry-content --> 
                </div><!-- .entry-summary -->
            </article>
	   <?php endwhile; endif;
       wp_reset_postdata();
	}
endif;
add_action( 'personify_pro_event_page_content_action', 'personify_pro_event_page_content', 10 );
