<?php
/**
 * Template Name: Event Template
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

get_header(); 
$options = personify_pro_get_theme_options(); 
$category = ! empty( $options['event_page_category'] ) ? $options['event_page_category'] : '';
$event_count = ! empty( $options['event_page_count'] ) ? $options['event_page_count'] : 5;
$post_count = '';
if ( ! empty( $category ) ) {
	$cat_obj 	= get_category( $category );
	$post_count = $cat_obj->category_count;
}

/**
 * personify_pro_simple_breadcrumb_action hook
 *
 * @hooked personify_pro_add_breadcrumb -  10
 *
 */
do_action( 'personify_pro_simple_breadcrumb_action' );
?>
<div id="page-title" class="relative">
    <div class="wrapper">
        <header class="page-header">
        
			<?php
			if ( false === $options['title_break'] ) :
				the_title( '<h2 class="entry-title">', '</h2>' );
			else :
				$title = explode( ' ', get_the_title() );
				$first_word = $title[0];
				$title = implode( ' ', array_slice( $title, 1 ) );
				?>
				<h2 class="entry-title"><span><?php echo esc_html( $first_word ); ?></span> <?php echo esc_html( $title ); ?></h2>
			<?php endif; ?>

		</header><!-- .entry-header -->
    </div><!-- .wrapper -->
</div><!-- #page-title -->

<div class="wrapper page-section no-padding-top">
    <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main">
            <div class="events-list-wrapper">
                <div class="todays-events-lists">
                    <div class="todays-events">
                        <?php  
                    	/**
						 * personify_pro_event_page_content_action hook
						 *
						 * @hooked personify_pro_event_page_content -  10
						 *
						 */
                    	do_action( 'personify_pro_event_page_content_action' );
                        
                        if ( ! empty( $category ) && $post_count < $event_count ) : ?>
	                    <span class="read-more">
	                    	<a href="<?php echo esc_url( get_category_link( $category ) );  ?>">
	                    		<?php 
	                    		esc_html_e( 'View All ', 'personify-pro' );
	                    		echo esc_html( get_the_category_by_id( $category ) ); 
	                    		?>
	                    	</a>
	                    </span>
	                <?php endif; ?>
                    </div><!-- .todays-events -->
                </div><!-- .todays-events-lists -->

                <?php if ( true === $options['event_calendar_enable'] ) : ?>
	                <div class="event-calendar">
	                    <?php the_widget( 'WP_Widget_Calendar' ); ?>
	                </div><!-- .event-calendar -->
	            <?php endif; ?>
            </div><!-- .events-list-wrapper -->
        </main>
    </div><!-- #primary -->
</div><!-- .wrapper -->

<?php  
get_footer();
