<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Personify Pro
	 * @since Personify Pro 1.0
	 */

	/**
	 * personify_pro_doctype hook
	 *
	 * @hooked personify_pro_doctype -  10
	 *
	 */
	do_action( 'personify_pro_doctype' );

?>
<head>
<?php
	/**
	 * personify_pro_before_wp_head hook
	 *
	 * @hooked personify_pro_head -  10
	 *
	 */
	do_action( 'personify_pro_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * personify_pro_page_start_action hook
	 *
	 * @hooked personify_pro_page_start -  10
	 *
	 */
	do_action( 'personify_pro_page_start_action' ); 

	/**
	 * personify_pro_loader_action hook
	 *
	 * @hooked personify_pro_loader -  10
	 * @hooked personify_pro_add_breadcrumb -  20
	 *
	 */
	do_action( 'personify_pro_before_header' );

	/**
	 * personify_pro_header_action hook
	 *
	 * @hooked personify_pro_header_start -  10
	 * @hooked personify_pro_site_branding -  20
	 * @hooked personify_pro_site_navigation -  30
	 * @hooked personify_pro_header_end -  50
	 *
	 */
	do_action( 'personify_pro_header_action' );

	/**
	 * personify_pro_content_start_action hook
	 *
	 * @hooked personify_pro_content_start -  10
	 *
	 */
	do_action( 'personify_pro_content_start_action' );

	/**
	* personify_pro_primary_content hook
	*
	* @hooked personify_pro_add_introduction_section - 10
	* @hooked personify_pro_add_about_section - 20
	* @hooked personify_pro_add_featured_section - 30
	* @hooked personify_pro_add_quotation_section - 40
	* @hooked personify_pro_add_video_section - 50
	* @hooked personify_pro_add_journey_section - 60
	* @hooked personify_pro_add_message_section - 70
	* @hooked personify_pro_add_event_section - 80
	* @hooked personify_pro_add_testimonial_section - 90
	*
	*/
    if ( is_front_page() && ! is_home() ) {
		do_action( 'personify_pro_primary_content' );
	}