<?php
/**
 * Core file.
 *
 * This is the template that includes all the other files for core featured of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */
function personify_pro_pro_theme_updater() {
    if( is_admin() ) {
        require get_template_directory() . '/inc/updater/theme-updater.php';
    }
}
add_action( 'after_setup_theme', 'personify_pro_pro_theme_updater' );

/**
 * Include options function.
 */
require get_template_directory() . '/inc/options.php';


// Load customizer defaults values
require get_template_directory() . '/inc/customizer/defaults.php';

/**
 * Function to detect SCRIPT_DEBUG on and off.
 * @return string If on, empty else return .min string.
 */
function personify_pro_min() {
    return defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
}

/**
 * Merge values from default options array and values from customizer
 *
 * @return array Values returned from customizer
 * @since Personify Pro 1.0
 */
function personify_pro_get_theme_options() {
  $personify_pro_default_options = personify_pro_get_default_theme_options();

  return array_merge( $personify_pro_default_options , get_theme_mod( 'personify_pro_theme_options', $personify_pro_default_options ) ) ;
}

/**
 * Display custom color CSS.
 */
function personify_pro_colors_css_wrap() {
    $options= personify_pro_get_theme_options();
    if ( 'custom' !== $options['colorscheme'] ) {
        return;
    }

    require_once get_template_directory() . '/inc/color-pattern.php';
    $color = $options['colorscheme_hue'];
    ?>
    <style type="text/css" id="custom-theme-colors" <?php if ( is_customize_preview() ) { echo 'data-color="' . $color . '"'; } ?>>
        <?php echo personify_pro_custom_colors_css(); ?>
    </style>
<?php }
add_action( 'wp_head', 'personify_pro_colors_css_wrap' );

/**
 * Load admin custom styles
 */
function load_pro_load_admin_style() {
    wp_register_style( 'load_pro_admin_css', get_template_directory_uri() . '/assets/css/admin-style' . personify_pro_min() . '.css', false, '1.0.0' );
    wp_enqueue_style( 'load_pro_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'load_pro_load_admin_style' );

/**
 * Add breadcrumb functions.
 */
require get_template_directory() . '/inc/breadcrumb-class.php';

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/helpers.php';

/**
 * Add structural hooks.
 */
require get_template_directory() . '/inc/structure.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Home page Sections
 */
require get_template_directory() . '/inc/sections/sections.php';

/**
 * Custom widget additions.
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Metabox additions.
 */
require get_template_directory() . '/inc/metabox.php';

require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
* TGM plugin additions.
*/
require get_template_directory() . '/inc/tgm-plugin/tgm-hook.php';

if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/inc/demo-import.php';
}

