<?php
/**
 * Sample implementation of the Custom Header feature.
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

if ( ! function_exists( 'personify_pro_header_style' ) ) :
	/**
	 * Styles the header image and text displayed on the blog.
	 *
	 * @see personify_pro_custom_header_setup().
	 */
	function personify_pro_header_style() {
		$options = personify_pro_get_theme_options();
		$css = '';

		$css .= '.trail-items li:not(:last-child):after {
			    content: "' . $options['breadcrumb_separator'] . '";
			}';

		$header_title_color = $options['header_title_color'];
		$header_tagline_color = $options['header_tagline_color'];


		$pagination_type = isset( $options['pagination_type'] ) ? $options['pagination_type'] : 'default';
		if ( $pagination_type == 'infinite' ) {
			$css .= '
			.site-main nav.pagination.navigation {
				display:none;
			}';
		}
		
		if ( $header_title_color && $header_tagline_color ) {

			$css .='
			.site-title a,
			#site-header .site-title a {
				color: '.esc_attr( $header_title_color ).';
			}
			.site-description {
				color: '.esc_attr( $header_tagline_color ).';
			}';
		}
		wp_add_inline_style( 'personify-pro-style', $css );
	}
endif;
add_action( 'wp_enqueue_scripts', 'personify_pro_header_style', 10 );