<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */


if ( ! function_exists( 'personify_pro_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'personify_pro_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'personify_pro_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'personify_pro_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'personify_pro_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'personify_pro_theme_options[pagination_enable]' )->value();
	}
endif;

if ( ! function_exists( 'personify_pro_is_footer_detail_enable' ) ) :
	/**
	 * Check if footer detail is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_footer_detail_enable( $control ) {
		return $control->manager->get_setting( 'personify_pro_theme_options[footer_detail_enable]' )->value();
	}
endif;

if ( ! function_exists( 'personify_pro_is_footer_name_enable' ) ) :
	/**
	 * Check if footer name is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_footer_name_enable( $control ) {
		return personify_pro_is_footer_detail_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[footer_name_enable]' )->value();
	}
endif;

if ( ! function_exists( 'personify_pro_is_single_social_share_enable' ) ) :
	/**
	 * Check if single social share is enabled.
	 *
	 * @since Personify Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_is_single_social_share_enable( $control ) {
		return personify_pro_is_footer_detail_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[single_post_show_social]' )->value();
	}
endif;


/* 
 * Front Page Setion
 */

/**
 * Check if introduction section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_introduction_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[introduction_section_enable]' )->value();
}

/**
 * Check if introduction section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_introduction_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[introduction_content_type]' )->value();
	return personify_pro_is_introduction_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if introduction section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_introduction_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[introduction_content_type]' )->value();
	return personify_pro_is_introduction_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if introduction section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_introduction_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[introduction_content_type]' )->value();
	return personify_pro_is_introduction_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if introduction section content type is not custom and demo.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_introduction_section_break_title( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[introduction_content_type]' )->value();
	return personify_pro_is_introduction_section_enable( $control ) && ( ! in_array( $content_type, array( 'demo', 'custom' ) ) );
}

/**
 * Check if about section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_about_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[about_section_enable]' )->value();
}

/**
 * Check if about section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_about_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[about_content_type]' )->value();
	return personify_pro_is_about_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if about section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_about_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[about_content_type]' )->value();
	return personify_pro_is_about_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if about section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_about_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[about_content_type]' )->value();
	return personify_pro_is_about_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if about section social section enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_about_social_section_enable( $control ) {
	return personify_pro_is_about_section_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[about_social_section_enable]' )->value();
}

/**
 * Check if featured posts section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_featured_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[featured_section_enable]' )->value();
}

/**
 * Check if featured post section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_featured_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[featured_content_type]' )->value();
	return personify_pro_is_featured_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if featured post section content type is category.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_featured_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[featured_content_type]' )->value();
	return personify_pro_is_featured_section_enable( $control ) && ( 'category' === $content_type );
}

/**
 * Check if featured image enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_featured_image_enable( $control ) {
	return personify_pro_is_featured_section_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[featured_image_enable]' )->value();
}

/**
 * Check if quotation section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[quotation_section_enable]' )->value();
}

/**
 * Check if quotation section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[quotation_content_type]' )->value();
	return personify_pro_is_quotation_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if quotation section content type is category.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[quotation_content_type]' )->value();
	return personify_pro_is_quotation_section_enable( $control ) && ( 'category' === $content_type );
}

/**
 * Check if quotation section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[quotation_content_type]' )->value();
	return personify_pro_is_quotation_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if quotation section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[quotation_content_type]' )->value();
	return personify_pro_is_quotation_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if quotation section content type is not post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_quotation_section_content_count_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[quotation_content_type]' )->value();
	return personify_pro_is_quotation_section_enable( $control ) && ( ! in_array( $content_type, array( 'demo', 'post' ) ) );
}

/**
 * Check if video section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_video_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[video_section_enable]' )->value();
}

/**
 * Check if journey section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_journey_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[journey_section_enable]' )->value();
}

/**
 * Check if journey section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_journey_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[journey_content_type]' )->value();
	return personify_pro_is_journey_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if journey section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_journey_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[journey_content_type]' )->value();
	return personify_pro_is_journey_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if journey section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_journey_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[journey_content_type]' )->value();
	return personify_pro_is_journey_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if journey section related media is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_journey_section_related_media_enable( $control ) {
	return personify_pro_is_journey_section_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[related_media_enable]' )->value();
}

/**
 * Check if message section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_message_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[message_section_enable]' )->value();
}

/**
 * Check if message section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_message_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[message_content_type]' )->value();
	return personify_pro_is_message_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if message section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_message_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[message_content_type]' )->value();
	return personify_pro_is_message_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if message section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_message_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[message_content_type]' )->value();
	return personify_pro_is_message_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if event section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_event_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[event_section_enable]' )->value();
}

/**
 * Check if event section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_event_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[event_content_type]' )->value();
	return personify_pro_is_event_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if event section content type is category.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_event_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[event_content_type]' )->value();
	return personify_pro_is_event_section_enable( $control ) && ( 'category' === $content_type );
}

/**
 * Check if testimonial section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[testimonial_section_enable]' )->value();
}

/**
 * Check if testimonial section content type is not post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_content_count_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[testimonial_content_type]' )->value();
	return personify_pro_is_testimonial_section_enable( $control ) && ( ! in_array( $content_type, array( 'demo', 'post' ) ) );
}

/**
 * Check if testimonial section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[testimonial_content_type]' )->value();
	return personify_pro_is_testimonial_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[testimonial_content_type]' )->value();
	return personify_pro_is_testimonial_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[testimonial_content_type]' )->value();
	return personify_pro_is_testimonial_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if testimonial section content type is category.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_testimonial_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[testimonial_content_type]' )->value();
	return personify_pro_is_testimonial_section_enable( $control ) && ( 'category' === $content_type );
}

/**
 * Check if social feeds section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_feeds_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[feeds_section_enable]' )->value();
}

/**
 * Check if subscription section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_subscription_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[subscription_section_enable]' )->value();
}

/*
 * Custom Template 
 */

/**
 * Check if career section in about template is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_career_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[career_section_enable]' )->value();
}

/**
 * Check if career section content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_career_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[career_content_type]' )->value();
	return personify_pro_is_career_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if career section content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_career_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[career_content_type]' )->value();
	return personify_pro_is_career_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if career section content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_career_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[career_content_type]' )->value();
	return personify_pro_is_career_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if skill section is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_skill_section_enable( $control ) {
	return class_exists( 'TP_PieBuilder' ) && personify_pro_is_career_section_enable( $control ) && $control->manager->get_setting( 'personify_pro_theme_options[skill_section_enable]' )->value();
}

/**
 * Check if portfolio section in about template is enabled.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_section_enable( $control ) {
	return $control->manager->get_setting( 'personify_pro_theme_options[portfolio_section_enable]' )->value();
}

/**
 * Check if portfolio note in about template content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_note_content_page( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_note_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'page' === $content_type );
}

/**
 * Check if portfolio note in about template content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_note_content_post( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_note_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if portfolio note in about template content type is custom.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_note_content_custom( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_note_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'custom' === $content_type );
}

/**
 * Check if portfolio in about template content type is not demo and post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_content_not_demo( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( ! in_array( $content_type, array( 'demo', 'post' ) ) );
}

/**
 * Check if portfolio in about template content type is category.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_content_category( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'category' === $content_type );
}

/**
 * Check if portfolio in about template content type is post.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_content_post( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'post' === $content_type );
}

/**
 * Check if portfolio in about template content type is page.
 *
 * @since Personify Pro 1.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function personify_pro_is_portfolio_content_page( $control ) {
	$content_type = $control->manager->get_setting( 'personify_pro_theme_options[portfolio_content_type]' )->value();
	return personify_pro_is_portfolio_section_enable( $control ) && ( 'page' === $content_type );
}

if ( ! function_exists( 'personify_pro_contact_map_content_embed' ) ) :
	/**
	 * Check if is contact map content is embed.
	 *
	 * @since Corporate Education Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_contact_map_content_embed( $control ) {
		$content_type = $control->manager->get_setting( 'personify_pro_theme_options[map_content_type]' )->value();
		if ( 'embed' === $content_type )
			return true;
		else
			return false;
	}
endif;

if ( ! function_exists( 'personify_pro_contact_map_content_shortcode' ) ) :
	/**
	 * Check if is contact map content is shortcode.
	 *
	 * @since Corporate Education Pro 1.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function personify_pro_contact_map_content_shortcode( $control ) {
		$content_type = $control->manager->get_setting( 'personify_pro_theme_options[map_content_type]' )->value();
		if ( 'shortcode' === $content_type )
			return true;
		else
			return false;
	}
endif;