<?php
/**
 * About us Template options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add About us career section
$wp_customize->add_section( 'personify_pro_about_career_section', array(
	'title'             => esc_html__( 'Career Section','personify-pro' ),
	'description'       => esc_html__( 'Career Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_about_us_panel',
) );

// Career content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[career_section_enable]', array(
	'default'			=> 	$options['career_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[career_section_enable]', array(
	'label'             => esc_html__( 'Career Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_about_career_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Career content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[career_content_type]', array(
	'default'          	=> $options['career_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[career_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_about_career_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_career_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[career_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[career_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_career_section',
	'active_callback' 	=> 'personify_pro_is_career_section_content_page_enable',
	'type'				=> 'dropdown-pages'
) );

// career Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[career_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[career_content_post]', array(
	'active_callback'	=> 'personify_pro_is_career_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_about_career_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// career title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[career_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['career_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[career_title]', array(
	'label'           	=> esc_html__( 'Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_career_section',
	'active_callback' 	=> 'personify_pro_is_career_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[career_title]', array(
		'selector'            => '#skills-section .wrapper .entry-header h2.entry-title',
		'settings'            => 'personify_pro_theme_options[career_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_career_title_partial',
    ) );
}

// About us description setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[career_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['career_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[career_description]', array(
	'label'           	=> esc_html__( 'Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_career_section',
	'active_callback' 	=> 'personify_pro_is_career_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[career_description]', array(
		'selector'            => '#skills-section .wrapper .entry-content',
		'settings'            => 'personify_pro_theme_options[career_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_career_description_partial',
    ) );
}

// Career skill content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[skill_section_enable]', array(
	'default'			=> 	$options['skill_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[skill_section_enable]', array(
	'label'             => esc_html__( 'Skills Enable', 'personify-pro' ),
	'description'       => sprintf( '%1$s <a href="' . esc_url( 'https://wordpress.org/plugins/tp-piebuilder/' ) . '" target="_blank"> %2$s </a> %3$s', esc_html__( 'Show your skills in horizontal line graph. Use shortcode from TP PieBuilder plugin. ', 'personify-pro' ), esc_html__( 'Click Here', 'personify-pro' ), esc_html__( 'to download.', 'personify-pro' ) ),
	'active_callback' 	=> 'personify_pro_is_career_section_enable',
	'section'           => 'personify_pro_about_career_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// career title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[skill_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[skill_shortcode]', array(
	'label'           	=> esc_html__( 'Shortcode', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_career_section',
	'active_callback' 	=> 'personify_pro_is_skill_section_enable',
	'type'				=> 'textarea',
) );