<?php
/**
 * About us Template options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add About us portfolio section
$wp_customize->add_section( 'personify_pro_about_portfolio_section', array(
	'title'             => esc_html__( 'Portfolio Section','personify-pro' ),
	'description'       => esc_html__( 'Portfolio Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_about_us_panel',
) );

// Portfolio content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_section_enable]', array(
	'default'			=> 	$options['portfolio_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[portfolio_section_enable]', array(
	'label'             => esc_html__( 'Portfolio Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Portfolio content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_note_content_type]', array(
	'default'          	=> $options['portfolio_note_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_note_content_type]', array(
	'label'             => esc_html__( 'Portfolio Introduction Type', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_portfolio_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_note_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_note_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_portfolio_section',
	'active_callback' 	=> 'personify_pro_is_portfolio_note_content_page',
	'type'				=> 'dropdown-pages'
) );

// portfolio Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_note_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_note_content_post]', array(
	'active_callback'	=> 'personify_pro_is_portfolio_note_content_post',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// portfolio title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_note_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['portfolio_note_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_note_title]', array(
	'label'           	=> esc_html__( 'Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_portfolio_section',
	'active_callback' 	=> 'personify_pro_is_portfolio_note_content_custom',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[portfolio_note_title]', array(
		'selector'            => '#movies-list .wrapper .entry-header h2.entry-title',
		'settings'            => 'personify_pro_theme_options[portfolio_note_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_portfolio_title_partial',
    ) );
}

// About us description setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_note_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['portfolio_note_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_note_description]', array(
	'label'           	=> esc_html__( 'Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_portfolio_section',
	'active_callback' 	=> 'personify_pro_is_portfolio_note_content_custom',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[portfolio_note_description]', array(
		'selector'            => '#movies-list .wrapper .entry-content',
		'settings'            => 'personify_pro_theme_options[portfolio_note_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_portfolio_description_partial',
    ) );
}

// Portfolio content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_content_type]', array(
	'default'          	=> $options['portfolio_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_content_type]', array(
	'label'             => esc_html__( 'Portfolio Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_portfolio_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'category' 	=> esc_html__( 'Category', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Portfolio number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_count]', array(
	'default'          	=> $options['portfolio_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_portfolio',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_count]', array(
	'label'             => esc_html__( 'Number of Portfolio', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'active_callback'   => 'personify_pro_is_portfolio_content_not_demo',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[portfolio_content_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[portfolio_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'personify_pro_is_portfolio_content_category'
) ) );

// Portfolio Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_content_post]', array(
	'sanitize_callback' => 'personify_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'personify_pro_theme_options[portfolio_content_post]', array(
	'active_callback'	=> 'personify_pro_is_portfolio_content_post',
	'label'             => esc_html__( 'Input Post Ids', 'personify-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'personify-pro' ),
	'section'           => 'personify_pro_about_portfolio_section',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['portfolio_count']; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[portfolio_content_page_' . $i . ']', array(
		'sanitize_callback' => 'personify_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[portfolio_content_page_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'personify-pro' ), $i ),
		'section'        	=> 'personify_pro_about_portfolio_section',
		'active_callback' 	=> 'personify_pro_is_portfolio_content_page',
		'type'				=> 'dropdown-pages'
	) );
}