<?php
/**
 * Contact Template options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Contact section
$wp_customize->add_section( 'personify_pro_contact_details_section', array(
	'title'             => esc_html__( 'Contact Detail Section','personify-pro' ),
	'description'       => esc_html__( 'Contact Detail options.', 'personify-pro' ),
	'panel'             => 'personify_pro_contact_panel',
) );

// contact address setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[contact_detail_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['contact_detail_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[contact_detail_title]', array(
	'label'           	=> esc_html__( 'Contact Detail Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_contact_details_section',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[contact_address]', array(
		'selector'            => '#contact-address .wrapper .custom-info .entry-content h2.widget-title',
		'settings'            => 'personify_pro_theme_options[contact_address]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_contact_detail_title_partial',
    ) );
}

// contact address setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[contact_address]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['contact_address'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[contact_address]', array(
	'label'           	=> esc_html__( 'Address', 'personify-pro' ),
	'section'        	=> 'personify_pro_contact_details_section',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[contact_address]', array(
		'selector'            => '#contact-address .wrapper .custom-info .entry-content span.address',
		'settings'            => 'personify_pro_theme_options[contact_address]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_contact_address_partial',
    ) );
}

// contact number setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[contact_phone]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['contact_phone'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[contact_phone]', array(
	'label'           	=> esc_html__( 'Phone', 'personify-pro' ),
	'section'        	=> 'personify_pro_contact_details_section',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[contact_phone]', array(
		'selector'            => '#contact-address .wrapper .custom-info .entry-content span.phone',
		'settings'            => 'personify_pro_theme_options[contact_phone]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_contact_phone_partial',
    ) );
}

// contact email setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[contact_email]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['contact_email'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[contact_email]', array(
	'label'           	=> esc_html__( 'Email', 'personify-pro' ),
	'section'        	=> 'personify_pro_contact_details_section',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[contact_email]', array(
		'selector'            => '#contact-address .wrapper .custom-info .entry-content span.email',
		'settings'            => 'personify_pro_theme_options[contact_email]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_contact_email_partial',
    ) );
}

// Add Contact section
$wp_customize->add_section( 'personify_pro_contact_map_section', array(
	'title'             => esc_html__( 'Map Section','personify-pro' ),
	'description'       => esc_html__( 'Map options.', 'personify-pro' ),
	'panel'             => 'personify_pro_contact_panel',
) );

// contact map content type setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[map_content_type]', array(
    'sanitize_callback' => 'personify_pro_sanitize_select',
    'default'           => $options['map_content_type'],
) );

$wp_customize->add_control( 'personify_pro_theme_options[map_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'personify-pro' ),
    'section'           => 'personify_pro_contact_map_section',
    'type'              => 'select',
    'choices'			=> array( 
		'embed' 		=> esc_html__( 'Embed', 'personify-pro' ),
		'shortcode' 	=> esc_html__( 'Shortcode', 'personify-pro' ),
		),
) );

// Add Map shortcode
$wp_customize->add_setting( 'personify_pro_theme_options[map_content_shortcode]', array(
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[map_content_shortcode]', array(
    'label'             => esc_html__( 'Input Map Shortcode', 'personify-pro' ),
    'description'       => sprintf( '%1$s <a href="' . esc_url( 'https://wordpress.org/plugins/wp-google-maps/' ) .'" target="_blank"> %2$s </a> %3$s', esc_html__( 'Input shortcode from WP Google Maps Plugin', 'personify-pro' ), esc_html__( 'Click Here', 'personify-pro' ), esc_html__( 'to download plugin.', 'personify-pro' ) ),
    'section'           => 'personify_pro_contact_map_section',
    'type'              => 'text',
    'active_callback'   => 'personify_pro_contact_map_content_shortcode',
) );

// Add Map embed
$wp_customize->add_setting( 'personify_pro_theme_options[map_content_embed]', array(
    'sanitize_callback' => 'personify_pro_santize_iframe_map',
) );

$wp_customize->add_control( 'personify_pro_theme_options[map_content_embed]', array(
    'label'             => esc_html__( 'Input Map Embed Code', 'personify-pro' ),
    'description'       => esc_html__( 'Notice: Please change both width and height value to 550.', 'personify-pro' ),
    'section'           => 'personify_pro_contact_map_section',
    'type'              => 'textarea',
    'active_callback'   => 'personify_pro_contact_map_content_embed',
) );

// Add Contact form section
$wp_customize->add_section( 'personify_pro_contact_form_section', array(
	'title'             => esc_html__( 'Contact Form Section','personify-pro' ),
	'description'       => esc_html__( 'Contact Form options.', 'personify-pro' ),
	'panel'             => 'personify_pro_contact_panel',
) );

// contact address setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[contact_form_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['contact_form_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[contact_form_title]', array(
	'label'           	=> esc_html__( 'Contact Form Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_contact_details_section',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[contact_form_title]', array(
		'selector'            => '#contact-form .wrapper .section-content .entry-header .entry-title',
		'settings'            => 'personify_pro_theme_options[contact_form_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_contact_address_partial',
    ) );
}

// Add Map shortcode
$wp_customize->add_setting( 'personify_pro_theme_options[form_content_shortcode]', array(
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[form_content_shortcode]', array(
    'label'             => esc_html__( 'Input Contact Form Shortcode', 'personify-pro' ),
    'description'       => sprintf( '%1$s <a href="' . esc_url( 'https://wordpress.org/plugins/contact-form-7/' ) .'" target="_blank"> %2$s </a> %3$s', esc_html__( 'Input shortcode from Contact Form 7 Plugin', 'personify-pro' ), esc_html__( 'Click Here', 'personify-pro' ), esc_html__( 'to download plugin.', 'personify-pro' ) ),
    'section'           => 'personify_pro_contact_form_section',
    'type'              => 'text',
) );