<?php
/**
 * Event Template options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Event section
$wp_customize->add_section( 'personify_pro_event_page_section', array(
	'title'             => esc_html__( 'Events Content','personify-pro' ),
	'description'       => esc_html__( 'Events Option', 'personify-pro' ),
	'panel'             => 'personify_pro_event_page_panel',
) );

// Testimonial number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_page_count]', array(
	'default'          	=> $options['event_page_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_event_page',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_page_count]', array(
	'label'             => esc_html__( 'Number of Events', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 25. Please input the valid number and save. Then refresh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_event_page_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 25,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[event_page_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[event_page_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest assigned number of event\'s content will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_event_page_section',
	'type'              => 'dropdown-taxonomies',
) ) );

// Add Event calendar section
$wp_customize->add_section( 'personify_pro_event_calendar_section', array(
	'title'             => esc_html__( 'Events Calendar Sidebar','personify-pro' ),
	'description'       => esc_html__( 'Events Calendar Sidebar Option', 'personify-pro' ),
	'panel'             => 'personify_pro_event_page_panel',
) );

// About us content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_calendar_enable]', array(
	'default'			=> 	$options['event_calendar_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[event_calendar_enable]', array(
	'label'             => esc_html__( 'Enable Calendar Sidebar', 'personify-pro' ),
	'section'           => 'personify_pro_event_calendar_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );
