<?php
/**
 * Theme Name Customizer.
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function personify_pro_customize_register( $wp_customize ) {
	$options = personify_pro_get_theme_options();

	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	// Remove the core header textcolor control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Header title color setting and control.
	$wp_customize->add_setting( 'personify_pro_theme_options[header_title_color]', array(
		'default'           => $options['header_title_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'personify_pro_theme_options[header_title_color]', array(
		'priority'			=> 5,
		'label'             => esc_html__( 'Header Title Color', 'personify-pro' ),
		'section'           => 'colors',
	) ) );

	// Header tagline color setting and control.
	$wp_customize->add_setting( 'personify_pro_theme_options[header_tagline_color]', array(
		'default'           => $options['header_tagline_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'personify_pro_theme_options[header_tagline_color]', array(
		'priority'			=> 6,
		'label'             => esc_html__( 'Header Tagline Color', 'personify-pro' ),
		'section'           => 'colors',
	) ) );

	// Site identity extra options.
	$wp_customize->add_setting( 'personify_pro_theme_options[header_txt_logo_extra]', array(
		'default'           => $options['header_txt_logo_extra'],
		'sanitize_callback' => 'personify_pro_sanitize_select',
		'transport'			=> 'refresh'
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[header_txt_logo_extra]', array(
		'priority'			=> 50,
		'type'				=> 'radio',
		'label'             => esc_html__( 'Site Identity Extra Options', 'personify-pro' ),
		'section'           => 'title_tagline',
		'choices'				=> array( 
			'hide-all'     => esc_html__( 'Hide All', 'personify-pro' ),
			'show-all'     => esc_html__( 'Show All', 'personify-pro' ),
			'title-only'   => esc_html__( 'Title Only', 'personify-pro' ),
			'tagline-only' => esc_html__( 'Tagline Only', 'personify-pro' ),
			'logo-title'   => esc_html__( 'Logo + Title', 'personify-pro' ),
			'logo-tagline' => esc_html__( 'Logo + Tagline', 'personify-pro' ),
			)
	) );

	/**
	 * Custom colors.
	 */
	$wp_customize->add_setting( 'personify_pro_theme_options[colorscheme]', array(
		'default'           => $options['colorscheme'],
		'sanitize_callback' => 'personify_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[colorscheme]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Color Scheme', 'personify-pro' ),
		'choices'  => array(
            'red'       => esc_html__( 'Red', 'personify-pro' ),
			'blue'      => esc_html__( 'Blue', 'personify-pro' ),
            'green'     => esc_html__( 'Green', 'personify-pro' ),
            'black'     => esc_html__( 'Black', 'personify-pro' ),
            'yellow'    => esc_html__( 'Yellow', 'personify-pro' ),
			'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		),
		'section'  => 'colors',
	) );

	$wp_customize->add_setting( 'personify_pro_theme_options[colorscheme_hue]', array(
		'default'           => $options['colorscheme_hue'],
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
	) );


	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'personify_pro_theme_options[colorscheme_hue]', array(
		'section'  => 'colors',
	) ) );

	// Add panel for common theme options
	$wp_customize->add_panel( 'personify_pro_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','personify-pro' ),
	    'description'=> esc_html__( 'Theme Palace Theme Options.', 'personify-pro' ),
	    'priority'   => 150,
	) );

	// loader
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// typography
	require get_template_directory() . '/inc/customizer/theme-options/typography.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// menu option
	require get_template_directory() . '/inc/customizer/theme-options/menu.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/archive.php';
	
	// load single post option
	require get_template_directory() . '/inc/customizer/theme-options/single-posts.php';

	// load breadcrumb option
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';

	// Add panel for front page theme options.
	$wp_customize->add_panel( 'personify_pro_front_page_panel' , array(
	    'title'      => esc_html__( 'Home Page','personify-pro' ),
	    'description'=> esc_html__( 'Home Page Theme Options.', 'personify-pro' ),
	    'priority'   => 140,
	) );

	// load introduction option
	require get_template_directory() . '/inc/customizer/sections/introduction.php';

	// load about us option
	require get_template_directory() . '/inc/customizer/sections/about.php';

	// load featured posts option
	require get_template_directory() . '/inc/customizer/sections/featured.php';

	// load quotation option
	require get_template_directory() . '/inc/customizer/sections/quotation.php';

	// load video option
	require get_template_directory() . '/inc/customizer/sections/video.php';

	// load journey option
	require get_template_directory() . '/inc/customizer/sections/journey.php';

	// load message option
	require get_template_directory() . '/inc/customizer/sections/message.php';

	// load event option
	require get_template_directory() . '/inc/customizer/sections/event.php';

	// load testimonial option
	require get_template_directory() . '/inc/customizer/sections/testimonial.php';

	// load feeds option
	require get_template_directory() . '/inc/customizer/sections/feeds.php';

	// load subscription option
	require get_template_directory() . '/inc/customizer/sections/subscription.php';


	// Add panel for about template options.
	$wp_customize->add_panel( 'personify_pro_about_us_panel' , array(
	    'title'      => esc_html__( 'About Us Template','personify-pro' ),
	    'description'=> esc_html__( 'About Us Template Options.', 'personify-pro' ),
	    'priority'   => 140,
	) );

	// load career option
	require get_template_directory() . '/inc/customizer/custom-template/about-career.php';

	// load portfolio option
	require get_template_directory() . '/inc/customizer/custom-template/about-portfolio.php';

	// Add panel for contact template options.
	$wp_customize->add_panel( 'personify_pro_contact_panel' , array(
	    'title'      => esc_html__( 'Contact Template','personify-pro' ),
	    'description'=> esc_html__( 'Contact Template Options.', 'personify-pro' ),
	    'priority'   => 140,
	) );

	// load contact option
	require get_template_directory() . '/inc/customizer/custom-template/contact.php';

	// Add panel for Event template options.
	$wp_customize->add_panel( 'personify_pro_event_page_panel' , array(
	    'title'      => esc_html__( 'Event Template','personify-pro' ),
	    'description'=> esc_html__( 'Event Template Options.', 'personify-pro' ),
	    'priority'   => 140,
	) );

	// load event option
	require get_template_directory() . '/inc/customizer/custom-template/event-page.php';

}
add_action( 'customize_register', 'personify_pro_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function personify_pro_customize_preview_js() {
	wp_enqueue_script( 'personify-pro-customizer', get_template_directory_uri() . '/assets/js/customizer' . personify_pro_min() . '.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'personify_pro_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function personify_pro_customize_control_js() {
	wp_enqueue_script( 'personify-pro-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls' . personify_pro_min() . '.js', array(), '1.0', true );
	$personify_pro_reset_data = array(
		'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'personify-pro' )
	);
	// Send list of color variables as object to custom customizer js
	wp_localize_script( 'personify-pro-customize-controls', 'personify_pro_reset_data', $personify_pro_reset_data );

	wp_enqueue_style( 'personify-pro-customize-controls', get_template_directory_uri() . '/assets/css/customize-controls' . personify_pro_min() . '.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'personify_pro_customize_control_js' );

if ( !function_exists( 'personify_pro_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since Personify Pro 1.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function personify_pro_reset_options() {
		$options = personify_pro_get_theme_options();
		if ( true === $options['reset_options'] ) {
			// Reset custom theme options.
			set_theme_mod( 'personify_pro_theme_options', array() );
			// Reset custom header and backgrounds.
			remove_theme_mod( 'header_image' );
			remove_theme_mod( 'header_image_data' );
			remove_theme_mod( 'background_image' );
			remove_theme_mod( 'background_color' );
			remove_theme_mod( 'header_textcolor' );
	    }
	  	else {
		    return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'personify_pro_reset_options' );
