<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 * @return array An array of default values
 */

function personify_pro_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$personify_pro_default_options = array(
		// Color Options
		'header_title_color'			=> '#000',
		'header_tagline_color'			=> '#000',
		'header_txt_logo_extra'			=> 'show-all',
		
		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',

		// color
		'colorscheme'					=> 'red',
		'colorscheme_hue'				=> '#dd9933',
		
		// loader
		'loader_enable'         		=> false,
		'loader_icon'         			=> 'default',
		
		// layout 
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> true,
		'menu_label_enable'				=> true,
		'title_break' 					=> true,

		// excerpt options
		'long_excerpt_length'           => 25,
		'read_more_text'		        => esc_html__( 'Read More', 'personify-pro' ),
		
		// breadcrumb options
		'breadcrumb_enable'         	=> true,
		'breadcrumb_separator'         	=> '-',

		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. All Rights Reserved', '1: Year, 2: Site Title with home URL', 'personify-pro' ), '[the-year]', '[site-link]' ),
		'powered_by_text'           	=> esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'personify-pro' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	=> true,
		'footer_detail_enable'        	=> true,
		'footer_name_enable'        	=> true,
		'footer_menu_enable'        	=> true,
		'footer_social_menu_enable'     => true,
		'footer_firstname'				=> esc_html__( 'Jake', 'personify-pro' ),
		'footer_lastname'				=> esc_html__( 'Gyllenhaal', 'personify-pro' ),

		// reset options
		'reset_options'      			=> false,
		
		// homepage options
		'enable_frontpage_content' 		=> false,

		// blog/archive options
		'archive_layout' 				=> 'list',
		'show_date' 					=> true,
		'show_author'					=> true,
		'show_category'					=> true,
		'show_comments'					=> true,
		'blog_title'					=> esc_html__( 'Blogs', 'personify-pro' ),

		// single post theme options
		'single_post_show_date' 		=> true,
		'single_post_show_author'		=> true,
		'single_post_show_pagination'	=> true,
		'single_post_show_category'		=> true,
		'single_post_show_tags'			=> true,
		'single_post_show_comments'		=> true,
		'single_post_show_related'		=> true,
		'single_post_show_social'		=> true,
		'single_post_show_facebook'		=> true,
		'single_post_show_twitter'		=> true,
		'single_post_show_google'		=> true,

		// Introduction Section
		'introduction_section_enable'	=> true,
		'introduction_title_break'		=> false,
		'introduction_content_type'		=> 'demo',
		'introduction_image_align'		=> 'right',
		'introduction_firstname'		=> esc_html__( 'Jake', 'personify-pro' ),
		'introduction_lastname'			=> esc_html__( 'Gyllenhaal', 'personify-pro' ),
		'introduction_profession'		=> esc_html__( 'Famous American Actor', 'personify-pro' ),
		'introduction_short_description'	=> esc_html__( 'I\'m a American actor who played in various famous movies like Source Code, Love & other Drugs, Everest...', 'personify-pro' ),
		'introduction_image'			=> get_template_directory_uri() . '/assets/uploads/jake.jpg',

		// About Us Section
		'about_section_enable'			=> true,
		'about_content_type'			=> 'demo',
		'about_title'					=> sprintf( '<span> %1$s </span> %2$s <span> %3$s </span> %4$s', esc_html__( 'Jake Gyllenhaal', 'personify-pro' ), esc_html__( 'is an american', 'personify-pro' ), esc_html__( 'Actor', 'personify-pro' ), esc_html__( ' a leo quis massa interdum porttitor eu at.', 'personify-pro' ) ),
		'about_sub_title'				=> esc_html__( 'He is an American actor who played in various famous movies like Source Code, Love and other Drugs, Everest...', 'personify-pro' ),
		'about_description'				=> sprintf( '%1$s <br/> %2$s ', esc_html__( 'Gyllenhaal pulvinar lacus purus, eget laoreet massa accumsan quis. Que mattis bibendum felis, sit amet blandit quam fini buset ed  vitae elit vitae ligula pretium efficitur nec non massa. Sed posuere pellentesque justo, vitae elementum tellus suscipit in. Integer semper velit sit amet libero luctus, vitae interdum dui tempor. In lacinia neque at tristique vulputate. Donec semper est faucibus varius egestas. Sed tristique, augue quis tempor gravida, ligula tellus convallis ipsum, vestibulum ultrices dui erat vitae erat. Donec eget ante et nunc auctor congue. Interdum et malesuada fames ac ante ipsum primis in faucibus.', 'personify-pro' ), esc_html__( 'Quisque dignissim, leo sed venenatis dapibus, mi nunc euismod neque, eget malesuada est nisi nec justo. Duis ultricies nulla sed mauris eleifend accumsan.', 'personify-pro' ) ),
		'about_social_section_enable'	=> false,

		// Featured Posts Section
		'featured_section_enable'		=> true,
		'featured_content_type'			=> 'demo',
		'featured_image_enable'			=> true,
		'featured_image_align'			=> 'right',
		'featured_image_caption'		=> sprintf( '%1$s <span> %2$s </span> ', esc_html__( 'An American', 'personify-pro' ), esc_html__( 'Actor', 'personify-pro' ) ),
		'featured_image'				=> get_template_directory_uri() . '/assets/uploads/american-actor.jpg',

		// Quotation Section
		'quotation_section_enable'		=> true,
		'quotation_content_type'		=> 'demo',
		'quotation_count'				=> 3,
		'quotation_content_custom'		=> esc_html__( 'Being a star doesn\'t last. That\'s not what life should be about. It\'s a complete illusion that really has nothing to do with you. For me, finding out about life is the most important thing.', 'personify-pro' ),

		// Featured video
		'video_section_enable'			=> true,
		'video_section_url'				=> esc_url_raw( 'https://www.youtube.com/watch?v=PGwHhZLpIWo' ),

		// Journey Section
		'journey_section_enable'		=> true,
		'journey_content_type'			=> 'demo',
		'journey_title'					=> esc_html__( 'My Journey', 'personify-pro' ),
		'journey_description'			=> sprintf( '%1$s <br/> %2$s', esc_html__( 'Maecenas in orci enim. Maecenas eu nisl dapibus, blandit massa sed, sodales leo. Donec a semper velit. Duis sed porttitor urna, sit amet ullamcorper lorem. Nam enim ligula, dapibus at blandit sed, pharetra in lectus. Quisque tincidunt ipsum nec orci facilisis faucibus. Pellentesque ac cursus dui. Quisque lectus augue, dignissim ac tellus finibus, fringilla ultrices sem. Donec nibh erat, maximus a tristique ut, ornare in metus. Nunc consectetur erat velit, sit amet sagittis tellus luctus at. In hac habitasse platea dictumst.', 'personify-pro' ), esc_html__( 'Sed id lorem semper, iaculis ligula a, bibendum tortor. Cras non tempor mauris.Curabitur tristique magna vitae lorem venenatis, eu laoreet nisl ultricies. Phasellus lacinia vehicula tincidunt.', 'personify-pro' ) ),
		'journey_featured_image'		=> get_template_directory_uri() . '/assets/uploads/journey-01.jpg',
		'related_media_enable'			=> true,
		'related_featured_image'		=> get_template_directory_uri() . '/assets/uploads/journey-02.jpg',
		'related_featured_video'		=> esc_url_raw( 'https://www.youtube.com/watch?v=Y3PgFEC7a0I' ),

		// Message Section
		'message_section_enable'		=> true,
		'message_content_type'			=> 'demo',
		'message_content_custom'		=> esc_html__( '"I hope that when the world comes to an end, I can breathe a sigh of relief, because there will be so much to look forward to."', 'personify-pro' ),

		// Event Section
		'event_section_enable'			=> true,
		'event_content_type'			=> 'demo',
		'event_section_count'			=> 5,
		'event_content_align'			=> 'right',
		'event_background_image'		=> get_template_directory_uri() . '/assets/uploads/upcoming-event.jpg',
		'event_section_title'			=> esc_html__( 'Upcoming Events', 'personify-pro' ),
		'event_section_description'		=> esc_html__( 'Maecenas in orci enim. Maecenas eu nisl dapibus, blandit massa sed, sodales leo. Donec a semper velit. Duis sed porttitor urna, sit amet ullamcorper lorem. Nam enim ligula, dapibus at blandit sed, pharetra in lectus. ', 'personify-pro' ),
		'event_social_count'			=> 1,
		'event_social_link'				=> esc_url_raw( 'http://facebook.com' ),
		'event_social_label'			=> esc_html__( 'Like Us for more info about events', 'personify-pro' ),

		// Testimonial Section
		'testimonial_section_enable'	=> true,
		'testimonial_title'				=> esc_html__( 'Their Thoughts', 'personify-pro' ),
		'testimonial_content_type'		=> 'demo',
		'testimonial_count'				=> 3,

		// Feeds Section
		'feeds_section_enable'			=> true,
		'feeds_title'					=> esc_html__( 'Follow on Instagram', 'personify-pro' ),
		'instagram_column'				=> 'col-4',
		'instagram_count'				=> 4,

		// Subscription Section
		'subscription_section_enable'	=> false,
		'subscription_title'			=> esc_html__( 'SignUp with Our Newsletter', 'personify-pro' ),

		// About Us Template
		'career_section_enable'			=> true, 
		'career_content_type'			=> 'demo',
		'career_title'					=> esc_html__( 'My Career', 'personify-pro' ),
		'career_description'			=> sprintf( '%1$s <br/> %2$s', esc_html__( 'Quisque sodales purus sit amet libero pellentesque cursus. Sed blandit nisl purus, ac rutrum risus bibendum interdum. Quisque tincidunt sapien non lorem rhoncus euismod. Nullam hendrerit dapibus volutpat. Nunc at egestas eros. Cras ultrices libero lorem. Mauris hendrerit ut lectus id pellentesque. Nam rutrum condimentum rutrum. Nulla id ante nibh. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.', 'personify-pro' ), esc_html__( 'Mauris hendrerit ut lectus id pellentesque. Nam rutrum condimentum rutrum. Nulla id ante nibh. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.', 'personify-pro' ) ),
		'skill_section_enable'			=> true,
		'portfolio_section_enable'		=> true,
		'portfolio_note_content_type'	=> 'demo',
		'portfolio_note_title'			=> esc_html__( 'My Movies', 'personify-pro' ),
		'portfolio_note_description'	=> esc_html__( 'Sed id lorem semper, iaculis ligula a, bibendum tortor. Cras non tempor mauris.Curabitur tristique magna vitae lorem venenatis, eu laoreet nisl ultricies. Phasellus lacinia vehicula tincidunt.', 'personify-pro' ),
		'portfolio_content_type'		=> 'demo',
		'portfolio_count'				=> 4,

		// Contact Template
		'contact_detail_title'			=> esc_html__( 'Jake Gallenhaal', 'personify-pro' ),
		'contact_address'				=> esc_html__( '155 Spring Street, 6th Floor New York, NY 10012', 'personify-pro' ),
		'contact_phone'					=> esc_html__( '310-272-7000, 212-334-0333 424-288-2000', 'personify-pro' ),
		'contact_email'					=> esc_html__( 'jakegallenhaal@email.com, jakegallenhaal@xyz.com', 'personify-pro' ),
		'map_content_type'				=> 'embed',
		'contact_form_title'			=> esc_html__( 'Send Us a Message', 'personify-pro' ),

		// Event Template
		'event_page_count'				=> 5,
		'event_calendar_enable'			=> true,

	);

	$output = apply_filters( 'personify_pro_default_theme_options', $personify_pro_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}