<?php
/**
 * About us Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add About us section
$wp_customize->add_section( 'personify_pro_about_section', array(
	'title'             => esc_html__( 'About us Section','personify-pro' ),
	'description'       => esc_html__( 'About us Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// About us content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About us Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_about_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// About us content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[about_content_type]', array(
	'default'          	=> $options['about_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_about_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_about_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[about_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_section',
	'active_callback' 	=> 'personify_pro_is_about_section_content_page_enable',
	'type'				=> 'dropdown-pages'
) );

// About us Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[about_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_content_post]', array(
	'active_callback'	=> 'personify_pro_is_about_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_about_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// About us title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[about_title]', array(
	'sanitize_callback' => 'personify_pro_santize_span',
	'default'          	=> $options['about_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_title]', array(
	'label'           	=> esc_html__( 'Title', 'personify-pro' ),
	'description'       => sprintf( esc_html( '%1$s <span> %2$s </span>' ), esc_html__( 'Note: To highlight certain element of the title, you can use html code as shown.', 'personify-pro' ), esc_html__( 'highlighted string', 'personify-pro' ) ),
	'section'        	=> 'personify_pro_about_section',
	'active_callback' 	=> 'personify_pro_is_about_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[about_title]', array(
		'selector'            => '#about-section .wrapper .entry-header h2.entry-title',
		'settings'            => 'personify_pro_theme_options[about_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_about_title_partial',
    ) );
}

// About us sub title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[about_sub_title]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['about_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'personify-pro' ),
	'description'       => esc_html__( 'Input field for short note or slogan.', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_section',
	'active_callback' 	=> 'personify_pro_is_about_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[about_sub_title]', array(
		'selector'            => '#about-section .wrapper .description',
		'settings'            => 'personify_pro_theme_options[about_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_about_sub_title_partial',
    ) );
}

// About us description setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[about_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['about_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[about_description]', array(
	'label'           	=> esc_html__( 'Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_about_section',
	'active_callback' 	=> 'personify_pro_is_about_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[about_description]', array(
		'selector'            => '#about-section .wrapper .entry-content p',
		'settings'            => 'personify_pro_theme_options[about_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_about_description_partial',
    ) );
}

// About us social icons enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[about_social_section_enable]', array(
	'default'			=> 	$options['about_social_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[about_social_section_enable]', array(
	'label'             => esc_html__( 'About us Social Section Enable', 'personify-pro' ),
	'description'       => sprintf( '%1$s <a href="' . admin_url( '/customize.php?autofocus[panel]=nav_menus' ) . '"> %2$s </a> %3$s', esc_html__( 'Note: Create social menu to show social links.', 'personify-pro' ), esc_html__( 'Click Here', 'personify-pro' ), esc_html__( 'to create menu', 'personify-pro' ) ),
	'section'           => 'personify_pro_about_section',
	'on_off_label' 		=> personify_pro_enable_options(),
	'active_callback' 	=> 'personify_pro_is_about_section_enable',
) ) );
