<?php
/**
 * Event Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Event section
$wp_customize->add_section( 'personify_pro_event_section', array(
	'title'             => esc_html__( 'Event Section','personify-pro' ),
	'description'       => esc_html__( 'Event Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Event content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_section_enable]', array(
	'default'			=> 	$options['event_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[event_section_enable]', array(
	'label'             => esc_html__( 'Event Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Event title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[event_section_title]', array(
	'default' 			=> $options['event_section_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage'
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_section_title]', array(
	'label'           	=> esc_html__( 'Event Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_event_section',
	'active_callback' 	=> 'personify_pro_is_event_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[event_section_title]', array(
		'selector'            => '#upcoming-events .wrapper .section-header h2.section-title',
		'settings'            => 'personify_pro_theme_options[event_section_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_event_title_partial',
    ) );
}

// Event description setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[event_section_description]', array(
	'default' 			=> $options['event_section_description'],
	'sanitize_callback' => 'wp_kses_post',
	'transport'			=> 'postMessage'
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_section_description]', array(
	'label'           	=> esc_html__( 'Event Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_event_section',
	'active_callback' 	=> 'personify_pro_is_event_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[event_section_description]', array(
		'selector'            => '#upcoming-events .wrapper .event-short-description p',
		'settings'            => 'personify_pro_theme_options[event_section_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_event_description_partial',
    ) );
}

// Event content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_content_type]', array(
	'default'          	=> $options['event_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_event_section_enable',
	'choices'			=> array( 
		'demo' 			=> esc_html__( 'Demo', 'personify-pro' ),
		'post' 			=> esc_html__( 'Post', 'personify-pro' ),
		'category' 		=> esc_html__( 'Category', 'personify-pro' ),
	),
) );

// Event Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[event_content_post]', array(
	'sanitize_callback' => 'personify_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_content_post]', array(
	'active_callback'	=> 'personify_pro_is_event_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Ids', 'personify-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 10. ie: 11, 24, 34', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'type'				=> 'text',
) );

// Events number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_section_count]', array(
	'default'          	=> $options['event_section_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_event',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_section_count]', array(
	'label'             => esc_html__( 'Number of Events', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 5 & Max 10. Please input the valid number and save. Then referesh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'active_callback'   => 'personify_pro_is_event_section_content_category_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 5,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[event_content_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[event_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'personify_pro_is_event_section_content_category_enable'
) ) );

// Event content alignment control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_content_align]', array(
	'default'          	=> $options['event_content_align'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_content_align]', array(
	'label'             => esc_html__( 'Content Alignment', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'type'				=> 'radio',
	'active_callback' 	=> 'personify_pro_is_event_section_enable',
	'choices'			=> array( 
		'right' 	=> esc_html__( 'Right', 'personify-pro' ),
		'left' 		=> esc_html__( 'Left', 'personify-pro' ),
	),
) );


// Event additional image setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[event_background_image]', array(
	'sanitize_callback' => 'personify_pro_sanitize_image',
	'default' 			=> $options['event_background_image'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[event_background_image]',
		array(
		'label'       		=> esc_html__( 'Select Background Image', 'personify-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 1920, 1080 ),
		'section'     		=> 'personify_pro_event_section',
		'active_callback'	=> 'personify_pro_is_event_section_enable',
) ) );

// Event social icons number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[event_social_count]', array(
	'default'          	=> $options['event_social_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_event_social',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[event_social_count]', array(
	'label'             => esc_html__( 'Number of Social Links', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 5. Please input the valid number and save. Then refresh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_event_section',
	'active_callback'   => 'personify_pro_is_event_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 5,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['event_social_count']; $i ++ ) {
	// Event social hr setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[event_social_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Personify_Pro_Customize_Horizontal_Line( $wp_customize, 'personify_pro_theme_options[event_social_hr_'. $i .']',
		array(
			'section'         => 'personify_pro_event_section',
			'active_callback' => 'personify_pro_is_event_section_enable',
			'type'			  => 'hr'
	) ) );

	// Event social link setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[event_social_link_' . $i . ']', array(
		'default' 			=> $options['event_social_link'],
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[event_social_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Social Link %d', 'personify-pro' ), $i),
		'section'        	=> 'personify_pro_event_section',
		'active_callback' 	=> 'personify_pro_is_event_section_enable',
		'type'				=> 'url',
	) );

	// Event social link setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[event_social_label_' . $i . ']', array(
		'default' 			=> $options['event_social_label'],
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[event_social_label_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Social Link Label %d', 'personify-pro' ), $i),
		'section'        	=> 'personify_pro_event_section',
		'active_callback' 	=> 'personify_pro_is_event_section_enable',
		'type'				=> 'text',
	) );
}