<?php
/**
 * Featured Posts Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Featured Posts section
$wp_customize->add_section( 'personify_pro_featured_section', array(
	'title'             => esc_html__( 'Featured Posts Section','personify-pro' ),
	'description'       => esc_html__( 'Featured Posts Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Featured Posts content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[featured_section_enable]', array(
	'default'			=> 	$options['featured_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[featured_section_enable]', array(
	'label'             => esc_html__( 'Featured Posts Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Featurd Posts content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[featured_content_type]', array(
	'default'          	=> $options['featured_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[featured_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_featured_section_enable',
	'choices'			=> array( 
		'demo' 			=> esc_html__( 'Demo', 'personify-pro' ),
		'category' 		=> esc_html__( 'Category', 'personify-pro' ),
		'post' 			=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[featured_content_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[featured_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest three posts will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'personify_pro_is_featured_section_content_category_enable'
) ) );

// Featured posts Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[featured_content_post]', array(
	'sanitize_callback' => 'personify_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'personify_pro_theme_options[featured_content_post]', array(
	'active_callback'	=> 'personify_pro_is_featured_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Ids', 'personify-pro' ),
	'description'       => esc_html__( 'Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 3. ie: 11, 24, 34', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'type'				=> 'text',
) );

// Featured image content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[featured_image_enable]', array(
	'default'			=> 	$options['featured_image_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[featured_image_enable]', array(
	'label'             => esc_html__( 'Featured Image Enable', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'on_off_label' 		=> personify_pro_enable_options(),
	'active_callback' 	=> 'personify_pro_is_featured_section_enable',
) ) );

// Featured image alignment control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[featured_image_align]', array(
	'default'          	=> $options['featured_image_align'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[featured_image_align]', array(
	'label'             => esc_html__( 'Featured Image Alignment', 'personify-pro' ),
	'section'           => 'personify_pro_featured_section',
	'type'				=> 'radio',
	'active_callback' 	=> 'personify_pro_is_featured_image_enable',
	'choices'			=> array( 
		'right' 	=> esc_html__( 'Right', 'personify-pro' ),
		'left' 		=> esc_html__( 'Left', 'personify-pro' ),
	),
) );

// Featurd Posts image setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[featured_image]', array(
	'default'           => $options['featured_image'],
	'sanitize_callback' => 'personify_pro_sanitize_image'
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[featured_image]',
		array(
		'label'       		=> esc_html__( 'Featured Image', 'personify-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 748, 900 ),
		'section'     		=> 'personify_pro_featured_section',
		'active_callback'	=> 'personify_pro_is_featured_image_enable',
) ) );

// About us title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[featured_image_caption]', array(
	'sanitize_callback' => 'personify_pro_santize_span',
	'default'          	=> $options['featured_image_caption'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[featured_image_caption]', array(
	'label'           	=> esc_html__( 'Image Caption', 'personify-pro' ),
	'description'       => sprintf( esc_html( '%1$s <span> %2$s </span>' ), esc_html__( 'Note: To highlight certain element of the title, you can use html code as shown.', 'personify-pro' ), esc_html__( 'highlighted string', 'personify-pro' ) ),
	'section'        	=> 'personify_pro_featured_section',
	'active_callback' 	=> 'personify_pro_is_featured_image_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[featured_image_caption]', array(
		'selector'            => '#latest-posts .wrapper .featured-image-wrapper p.designation',
		'settings'            => 'personify_pro_theme_options[featured_image_caption]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_featured_caption_partial',
    ) );
}