<?php
/**
 * Social feeds Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Social feeds section
$wp_customize->add_section( 'personify_pro_feeds_section', array(
	'title'             => esc_html__( 'Social Feeds Section','personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Social feeds content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[feeds_section_enable]', array(
	'default'			=> 	$options['feeds_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[feeds_section_enable]', array(
	'label'             => esc_html__( 'Instagram Feeds Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_feeds_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Introduction firstname setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[feeds_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['feeds_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[feeds_title]', array(
	'label'           	=> esc_html__( 'Social Feeds Section Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_feeds_section',
	'active_callback' 	=> 'personify_pro_is_feeds_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[feeds_title]', array(
		'selector'            => '#social-medias .wrapper .section-header h2.section-title',
		'settings'            => 'personify_pro_theme_options[feeds_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_feeds_title_partial',
    ) );
}

// Instagram Username setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[instagram_username]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[instagram_username]', array(
	'label'           	=> esc_html__( 'Instagram Access Token', 'personify-pro' ),
	'description'       => sprintf( esc_html__( 'Get your Instagram token ID from %1$s HERE %2$s', 'personify-pro' ), '<a target="_blank" href="https://instagram.pixelunion.net/">', '</a>' ),
	'section'        	=> 'personify_pro_feeds_section',
	'type'				=> 'text',
	'active_callback' 	=> 'personify_pro_is_feeds_section_enable',
) );

// Instagram feeds content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[instagram_column]', array(
	'default'          	=> $options['instagram_column'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[instagram_column]', array(
	'label'             => esc_html__( 'Columns Layout', 'personify-pro' ),
	'section'           => 'personify_pro_feeds_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_feeds_section_enable',
	'choices'			=> array( 
		'col-3' 	=> esc_html__( 'Three Columns', 'personify-pro' ),
		'col-4' 	=> esc_html__( 'Four Columns', 'personify-pro' ),
		'col-5' 	=> esc_html__( 'Five Columns', 'personify-pro' ),
	),
) );

// Instagram feeds number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[instagram_count]', array(
	'default'          	=> $options['instagram_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_feeds',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[instagram_count]', array(
	'label'             => esc_html__( 'Number of feeds', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 10. Please input the valid number and save.', 'personify-pro' ),
	'section'           => 'personify_pro_feeds_section',
	'active_callback'   => 'personify_pro_is_feeds_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );