<?php
/**
 * Introduction Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Introduction section
$wp_customize->add_section( 'personify_pro_introduction_section', array(
	'title'             => esc_html__( 'Introduction Section','personify-pro' ),
	'description'       => esc_html__( 'Introduction Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Introduction content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_section_enable]', array(
	'default'			=> 	$options['introduction_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[introduction_section_enable]', array(
	'label'             => esc_html__( 'Introduction Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_introduction_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Introduction content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_content_type]', array(
	'default'          	=> $options['introduction_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_introduction_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_introduction_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Introduction firstname setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_firstname]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['introduction_firstname'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_firstname]', array(
	'label'           	=> esc_html__( 'First Name', 'personify-pro' ),
	'section'        	=> 'personify_pro_introduction_section',
	'active_callback' 	=> 'personify_pro_is_introduction_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[introduction_firstname]', array(
		'selector'            => '#hero-section .wrapper .entry-header h2.entry-title span.first-name',
		'settings'            => 'personify_pro_theme_options[introduction_firstname]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_introduction_firstname_partial',
    ) );
}

// Introduction lastname setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_lastname]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['introduction_lastname'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_lastname]', array(
	'label'           	=> esc_html__( 'Last Name', 'personify-pro' ),
	'section'        	=> 'personify_pro_introduction_section',
	'active_callback' 	=> 'personify_pro_is_introduction_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[introduction_lastname]', array(
		'selector'            => '#hero-section .wrapper .entry-header h2.entry-title span.last-name',
		'settings'            => 'personify_pro_theme_options[introduction_lastname]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_introduction_lastname_partial',
    ) );
}

// Introduction profession setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_profession]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['introduction_profession'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_profession]', array(
	'label'           	=> esc_html__( 'Profession', 'personify-pro' ),
	'section'        	=> 'personify_pro_introduction_section',
	'active_callback' 	=> 'personify_pro_is_introduction_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[introduction_profession]', array(
		'selector'            => '#hero-section .wrapper .entry-header span.designation',
		'settings'            => 'personify_pro_theme_options[introduction_profession]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_introduction_profession_partial',
    ) );
}

// Introduction profession setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_short_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['introduction_short_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_short_description]', array(
	'label'           	=> esc_html__( 'Short Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_introduction_section',
	'active_callback' 	=> 'personify_pro_is_introduction_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[introduction_short_description]', array(
		'selector'            => '#hero-section .wrapper .entry-description .small-description',
		'settings'            => 'personify_pro_theme_options[introduction_short_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_introduction_short_description_partial',
    ) );
}

// Introduction Section image setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_image]', array(
	'sanitize_callback' => 'personify_pro_sanitize_image',
	'default' 			=> $options['introduction_image'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[introduction_image]',
		array(
		'label'       		=> esc_html__( 'Select Image', 'personify-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 1070, 1000 ),
		'section'     		=> 'personify_pro_introduction_section',
		'active_callback'	=> 'personify_pro_is_introduction_section_content_custom_enable',
) ) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'section'        	=> 'personify_pro_introduction_section',
	'active_callback' 	=> 'personify_pro_is_introduction_section_content_page_enable',
	'type'				=> 'dropdown-pages'
) );

// About us Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_content_post]', array(
	'active_callback'	=> 'personify_pro_is_introduction_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_introduction_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Title break setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_title_break]', array(
	'sanitize_callback'	=> 'personify_pro_sanitize_checkbox',
	'default'          	=> $options['introduction_title_break']
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_title_break]', array(
	'label'             => esc_html__( 'Break Title', 'personify-pro' ),
	'section'          	=> 'personify_pro_introduction_section',
	'active_callback'   => 'personify_pro_is_introduction_section_break_title',
	'type'             	=> 'checkbox',
) );

// Introduction content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[introduction_image_align]', array(
	'default'          	=> $options['introduction_image_align'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[introduction_image_align]', array(
	'label'             => esc_html__( 'Image Alignment', 'personify-pro' ),
	'section'           => 'personify_pro_introduction_section',
	'type'				=> 'radio',
	'active_callback' 	=> 'personify_pro_is_introduction_section_enable',
	'choices'			=> array( 
		'right' 	=> esc_html__( 'Right', 'personify-pro' ),
		'left' 		=> esc_html__( 'Left', 'personify-pro' ),
	),
) );
