<?php
/**
 * Journey Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Journey section
$wp_customize->add_section( 'personify_pro_journey_section', array(
	'title'             => esc_html__( 'Journey Section','personify-pro' ),
	'description'       => esc_html__( 'Journey Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Journey content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[journey_section_enable]', array(
	'default'			=> 	$options['journey_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[journey_section_enable]', array(
	'label'             => esc_html__( 'Journey Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_journey_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Journey content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[journey_content_type]', array(
	'default'          	=> $options['journey_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[journey_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_journey_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_journey_section_enable',
	'choices'			=> array( 
		'demo' 		=> esc_html__( 'Demo', 'personify-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'personify-pro' ),
		'page' 		=> esc_html__( 'Page', 'personify-pro' ),
		'post' 		=> esc_html__( 'Post', 'personify-pro' ),
	),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[journey_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[journey_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'section'        	=> 'personify_pro_journey_section',
	'active_callback' 	=> 'personify_pro_is_journey_section_content_page_enable',
	'type'				=> 'dropdown-pages'
) );

// Journey Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[journey_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[journey_content_post]', array(
	'active_callback'	=> 'personify_pro_is_journey_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_journey_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Journey title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[journey_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['journey_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[journey_title]', array(
	'label'           	=> esc_html__( 'Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_journey_section',
	'active_callback' 	=> 'personify_pro_is_journey_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[journey_title]', array(
		'selector'            => '#journey .wrapper .entry-header h2.entry-title',
		'settings'            => 'personify_pro_theme_options[journey_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_journey_title_partial',
    ) );
}

// Journey description setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[journey_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'          	=> $options['journey_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[journey_description]', array(
	'label'           	=> esc_html__( 'Description', 'personify-pro' ),
	'section'        	=> 'personify_pro_journey_section',
	'active_callback' 	=> 'personify_pro_is_journey_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[journey_description]', array(
		'selector'            => '#journey .wrapper .entry-content',
		'settings'            => 'personify_pro_theme_options[journey_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_journey_description_partial',
    ) );
}

// Journey featured image setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[journey_featured_image]', array(
	'sanitize_callback' => 'personify_pro_sanitize_image',
	'default' 			=> $options['journey_featured_image'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[journey_featured_image]',
		array(
		'label'       		=> esc_html__( 'Select Featured Image', 'personify-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 520, 616 ),
		'section'     		=> 'personify_pro_journey_section',
		'active_callback'	=> 'personify_pro_is_journey_section_content_custom_enable',
) ) );

// Journey additional media enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[related_media_enable]', array(
	'default'			=> 	$options['related_media_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[related_media_enable]', array(
	'label'             => esc_html__( 'Enable Related Media', 'personify-pro' ),
	'section'           => 'personify_pro_journey_section',
	'on_off_label' 		=> personify_pro_enable_options(),
	'active_callback' 	=> 'personify_pro_is_journey_section_enable',
) ) );

// Journey additional image setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[related_featured_image]', array(
	'sanitize_callback' => 'personify_pro_sanitize_image',
	'default' 			=> $options['related_featured_image'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[related_featured_image]',
		array(
		'label'       		=> esc_html__( 'Select Related Featured Image', 'personify-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 520, 616 ),
		'section'     		=> 'personify_pro_journey_section',
		'active_callback'	=> 'personify_pro_is_journey_section_related_media_enable',
) ) );

// video url setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[related_featured_video]', array(
	'default' 			=> $options['related_featured_video'],
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'personify_pro_theme_options[related_featured_video]', array(
	'label'           	=> esc_html__( 'Related Featured Video URL', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Input video url from youtube or media library.', 'personify-pro' ),
	'section'        	=> 'personify_pro_journey_section',
	'active_callback' 	=> 'personify_pro_is_journey_section_related_media_enable',
	'type'				=> 'url',
) );