<?php
/**
 * Message Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Message section
$wp_customize->add_section( 'personify_pro_message_section', array(
	'title'             => esc_html__( 'Personify Message Section','personify-pro' ),
	'description'       => esc_html__( 'Personify Message Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Message content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[message_section_enable]', array(
	'default'			=> 	$options['message_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[message_section_enable]', array(
	'label'             => esc_html__( 'Personify Message Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_message_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Featurd content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[message_content_type]', array(
	'default'          	=> $options['message_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[message_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_message_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_message_section_enable',
	'choices'			=> array( 
		'demo' 			=> esc_html__( 'Demo', 'personify-pro' ),
		'post' 			=> esc_html__( 'Post', 'personify-pro' ),
		'page' 			=> esc_html__( 'Page', 'personify-pro' ),
		'custom' 		=> esc_html__( 'Custom', 'personify-pro' ),
	),
) );

// Message Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[message_content_post]', array(
	'validate_callback' => 'personify_pro_validate_post_id',
	'sanitize_callback' => 'personify_pro_sanitize_single_post_id',
) );

$wp_customize->add_control( 'personify_pro_theme_options[message_content_post]', array(
	'active_callback'	=> 'personify_pro_is_message_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Id', 'personify-pro' ),
	'description'       => esc_html__( 'Please Input Valid Post Id. Simply hover post title on dashboard to see the Post ID.', 'personify-pro' ),
	'section'           => 'personify_pro_message_section',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'style'	=> 'width:100px',
		),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[message_content_page]', array(
	'sanitize_callback' => 'personify_pro_sanitize_page'
) );

$wp_customize->add_control( 'personify_pro_theme_options[message_content_page]', array(
	'label'           	=> esc_html__( 'Select Page', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Page\'s content will be shown from selected page', 'personify-pro' ),
	'section'        	=> 'personify_pro_message_section',
	'active_callback' 	=> 'personify_pro_is_message_section_content_page_enable',
	'type'				=> 'dropdown-pages'
) );

// custom message setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[message_content_custom]', array(
	'default' 			=> $options['message_content_custom'],
	'sanitize_callback' => 'wp_kses_post',
	'transport'			=> 'postMessage'
) );

$wp_customize->add_control( 'personify_pro_theme_options[message_content_custom]', array(
	'label'           	=> esc_html__( 'Message', 'personify-pro' ),
	'section'        	=> 'personify_pro_message_section',
	'active_callback' 	=> 'personify_pro_is_message_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[message_content_custom]', array(
		'selector'            => '#section-promotion .wrapper .entry-content .description',
		'settings'            => 'personify_pro_theme_options[message_content_custom]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_message_content_partial',
    ) );
}
