<?php
/**
 * Quotation Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Quotation section
$wp_customize->add_section( 'personify_pro_quotation_section', array(
	'title'             => esc_html__( 'Quotation Section','personify-pro' ),
	'description'       => esc_html__( 'Quotation Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Quotation content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[quotation_section_enable]', array(
	'default'			=> 	$options['quotation_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[quotation_section_enable]', array(
	'label'             => esc_html__( 'Quotation Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_quotation_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Featurd content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[quotation_content_type]', array(
	'default'          	=> $options['quotation_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[quotation_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_quotation_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_quotation_section_enable',
	'choices'			=> array( 
		'demo' 			=> esc_html__( 'Demo', 'personify-pro' ),
		'category' 		=> esc_html__( 'Category', 'personify-pro' ),
		'post' 			=> esc_html__( 'Post', 'personify-pro' ),
		'page' 			=> esc_html__( 'Page', 'personify-pro' ),
		'custom' 		=> esc_html__( 'Custom', 'personify-pro' ),
	),
) );

// Quotation number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[quotation_count]', array(
	'default'          	=> $options['quotation_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_quotation',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[quotation_count]', array(
	'label'             => esc_html__( 'Number of Quotation', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 5. Please input the valid number and save. Then refresh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_quotation_section',
	'active_callback'   => 'personify_pro_is_quotation_section_content_count_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 5,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[quotation_content_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[quotation_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest assigned number of quotation post\'s content will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_quotation_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'personify_pro_is_quotation_section_content_category_enable'
) ) );

// Quotation posts Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[quotation_content_post]', array(
	'sanitize_callback' => 'personify_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'personify_pro_theme_options[quotation_content_post]', array(
	'active_callback'	=> 'personify_pro_is_quotation_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Ids', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Post\'s content will be shown from selected posts. Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 5. ie: 11, 24, 34', 'personify-pro' ),
	'section'           => 'personify_pro_quotation_section',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['quotation_count']; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[quotation_content_page' . $i . ']', array(
		'sanitize_callback' => 'personify_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[quotation_content_page' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'personify-pro' ), $i ),
		'description'       => esc_html__( 'Note: Page\'s content will be shown from selected page', 'personify-pro' ),
		'section'        	=> 'personify_pro_quotation_section',
		'active_callback' 	=> 'personify_pro_is_quotation_section_content_page_enable',
		'type'				=> 'dropdown-pages'
	) );

	// custom quotation setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[quotation_content_custom_' . $i . ']', array(
		'default' 			=> $options['quotation_content_custom'],
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[quotation_content_custom_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Quotation %d', 'personify-pro' ), $i ),
		'section'        	=> 'personify_pro_quotation_section',
		'active_callback' 	=> 'personify_pro_is_quotation_section_content_custom_enable',
		'type'				=> 'textarea',
	) );
}