<?php
/**
 * Subscription Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Subscription section
$wp_customize->add_section( 'personify_pro_subscription_section', array(
	'title'             => esc_html__( 'Subscription Section','personify-pro' ),
	'description'       => sprintf( '%1$s <a href="' . esc_url( 'https://wordpress.org/plugins/jetpack/' ) . '" target="_blank"> %2$s </a>', esc_html__( 'Note: Please install Jetpack and enable subscription module. To install Jetpack ', 'personify-pro' ), esc_html__( 'Click Here', 'personify-pro' ) ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Subscription content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[subscription_section_enable]', array(
	'default'			=> 	$options['subscription_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[subscription_section_enable]', array(
	'label'             => esc_html__( 'Subscription Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_subscription_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// About us title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[subscription_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'          	=> $options['subscription_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[subscription_title]', array(
	'label'           	=> esc_html__( 'Subscription Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_subscription_section',
	'active_callback' 	=> 'personify_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[subscription_title]', array(
		'selector'            => '#subscribe-newsletter .wrapper .jetpack_subscription_widget h2.widgettitle',
		'settings'            => 'personify_pro_theme_options[subscription_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_subscription_title_partial',
    ) );
}
