<?php
/**
 * Testimonial Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Testimonial section
$wp_customize->add_section( 'personify_pro_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial Section','personify-pro' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Testimonial Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_testimonial_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Testimonial title setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_title]', array(
	'default' 			=> $options['testimonial_title'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[testimonial_title]', array(
	'label'           	=> esc_html__( 'Testimonial Section Title', 'personify-pro' ),
	'section'        	=> 'personify_pro_testimonial_section',
	'active_callback' 	=> 'personify_pro_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[testimonial_title]', array(
		'selector'            => '#client-testimonial .wrapper .section-header h2.section-title',
		'settings'            => 'personify_pro_theme_options[testimonial_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_testimonial_title_partial',
    ) );
}

// Testimonial content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_type]', array(
	'default'          	=> $options['testimonial_content_type'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'personify-pro' ),
	'section'           => 'personify_pro_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'personify_pro_is_testimonial_section_enable',
	'choices'			=> array( 
		'demo' 			=> esc_html__( 'Demo', 'personify-pro' ),
		'category' 		=> esc_html__( 'Category', 'personify-pro' ),
		'post' 			=> esc_html__( 'Post', 'personify-pro' ),
		'page' 			=> esc_html__( 'Page', 'personify-pro' ),
		'custom' 		=> esc_html__( 'Custom', 'personify-pro' ),
	),
) );

// Testimonial number control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_count]', array(
	'default'          	=> $options['testimonial_count'],
	'sanitize_callback' => 'personify_pro_sanitize_number_range',
	'validate_callback' => 'personify_pro_validate_no_of_testimonial',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'personify_pro_theme_options[testimonial_count]', array(
	'label'             => esc_html__( 'Number of Testimonial', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 5. Please input the valid number and save. Then refresh the page to see the change.', 'personify-pro' ),
	'section'           => 'personify_pro_testimonial_section',
	'active_callback'   => 'personify_pro_is_testimonial_section_content_count_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 5,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'personify_pro_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'personify_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Personify_Pro_Dropdown_Taxonomies_Control( $wp_customize,'personify_pro_theme_options[testimonial_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'personify-pro' ),
	'description'      	=> esc_html__( 'Note: Latest assigned number of testimonial post\'s content will be shown from selected category', 'personify-pro' ),
	'section'           => 'personify_pro_testimonial_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'personify_pro_is_testimonial_section_content_category_enable'
) ) );

// Testimonial posts Section content type post setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_post]', array(
	'sanitize_callback' => 'personify_pro_sanitize_post_ids',
) );

$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_post]', array(
	'active_callback'	=> 'personify_pro_is_testimonial_section_content_post_enable',
	'label'             => esc_html__( 'Input Post Ids', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Post\'s content will be shown from selected posts. Simply hover post title on dashboard to see the Post ID. Max no. of posts allowed is 5. ie: 11, 24, 34', 'personify-pro' ),
	'section'           => 'personify_pro_testimonial_section',
	'type'				=> 'text',
) );

for ( $i = 1; $i <= $options['testimonial_count']; $i++ ) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'personify_pro_sanitize_page'
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Select Page %d', 'personify-pro' ), $i ),
		'description'       => esc_html__( 'Note: Page\'s content will be shown from selected page', 'personify-pro' ),
		'section'        	=> 'personify_pro_testimonial_section',
		'active_callback' 	=> 'personify_pro_is_testimonial_section_content_page_enable',
		'type'				=> 'dropdown-pages'
	) );

	// Event social hr setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Personify_Pro_Customize_Horizontal_Line( $wp_customize, 'personify_pro_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'personify_pro_testimonial_section',
			'active_callback' => 'personify_pro_is_testimonial_section_content_custom_enable',
			'type'			  => 'hr'
	) ) );

	// custom testimonial setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'personify-pro' ), $i ),
		'section'        	=> 'personify_pro_testimonial_section',
		'active_callback' 	=> 'personify_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// custom testimonial setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_sub_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_sub_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Sub Title %d', 'personify-pro' ), $i ),
		'section'        	=> 'personify_pro_testimonial_section',
		'active_callback' 	=> 'personify_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// custom testimonial setting and control
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'personify_pro_theme_options[testimonial_content_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Testimonial Content %d', 'personify-pro' ), $i ),
		'section'        	=> 'personify_pro_testimonial_section',
		'active_callback' 	=> 'personify_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// custom testimonial image setting and control.
	$wp_customize->add_setting( 'personify_pro_theme_options[testimonial_content_image_' . $i . ']', array(
		'sanitize_callback' => 'personify_pro_sanitize_image',
	) );

	$wp_customize->add_control(
		new WP_Customize_Image_Control( $wp_customize, 'personify_pro_theme_options[testimonial_content_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Select Image %d', 'personify-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'personify-pro' ), 150, 150 ),
			'section'     		=> 'personify_pro_testimonial_section',
			'active_callback'	=> 'personify_pro_is_testimonial_section_content_custom_enable',
	) ) );
}