<?php
/**
 * Featured Video Section options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add Featured Video section
$wp_customize->add_section( 'personify_pro_video_section', array(
	'title'             => esc_html__( 'Featured Video Section','personify-pro' ),
	'description'       => esc_html__( 'Featured Video Section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_front_page_panel',
) );

// Featured Video content enable control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[video_section_enable]', array(
	'default'			=> 	$options['video_section_enable'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[video_section_enable]', array(
	'label'             => esc_html__( 'Featured Video Section Enable', 'personify-pro' ),
	'section'           => 'personify_pro_video_section',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// video url setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[video_section_url]', array(
	'default' 			=> $options['video_section_url'],
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'personify_pro_theme_options[video_section_url]', array(
	'label'           	=> esc_html__( 'Featured Video URL', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Input video url from youtube or media library.', 'personify-pro' ),
	'section'        	=> 'personify_pro_video_section',
	'active_callback' 	=> 'personify_pro_is_video_section_enable',
	'type'				=> 'url',
) );