<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add archive section
$wp_customize->add_section( 'personify_pro_archive_section', array(
	'title'             => esc_html__( 'Blog/Archive','personify-pro' ),
	'description'       => esc_html__( 'Archive section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_theme_options_panel',
) );

// Blog Title control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[blog_title]', array(
	'default'          	=> $options['blog_title'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'personify_pro_theme_options[blog_title]', array(
	'label'             => esc_html__( 'Blog Page Title', 'personify-pro' ),
	'description'       => esc_html__( 'Note: Blog page title will be visible if the Static Front Page option in customizer is "Your Latest Post".', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'type'				=> 'text',
) );

// Featurd Posts content type control and setting
$wp_customize->add_setting( 'personify_pro_theme_options[archive_layout]', array(
	'default'          	=> $options['archive_layout'],
	'sanitize_callback' => 'personify_pro_sanitize_select',
) );

$wp_customize->add_control( 'personify_pro_theme_options[archive_layout]', array(
	'label'             => esc_html__( 'Layout', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'type'				=> 'radio',
	'choices'			=> array( 
		'list' 			=> esc_html__( 'List View', 'personify-pro' ),
		'blog-list' 	=> esc_html__( 'Grid View', 'personify-pro' ),
	),
) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[show_date]', array(
	'default'           => $options['show_date'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[show_date]', array(
	'label'             => esc_html__( 'Show Date', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive author meta setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[show_author]', array(
	'default'           => $options['show_author'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[show_author]', array(
	'label'             => esc_html__( 'Show Author', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[show_category]', array(
	'default'           => $options['show_category'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[show_category]', array(
	'label'             => esc_html__( 'Show Category', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// Archive tag category setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[show_comments]', array(
	'default'           => $options['show_comments'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[show_comments]', array(
	'label'             => esc_html__( 'Show Comments Meta', 'personify-pro' ),
	'section'           => 'personify_pro_archive_section',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );

// service Section category setting and control
$wp_customize->add_setting( 'personify_pro_theme_options[blog_exclude_categories]', array(
	'sanitize_callback' => 'personify_pro_sanitize_category_list'
) );

$wp_customize->add_control( new Personify_Pro_Dropdown_Category_Control( $wp_customize, 'personify_pro_theme_options[blog_exclude_categories]', array(
	'label'           => esc_html__( 'Select Categories to Exclude in Blog Page', 'personify-pro' ),
	'section'         => 'personify_pro_archive_section',
	'type'			  => 'dropdown-categories',
) ) );
