<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

$wp_customize->add_section( 'personify_pro_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','personify-pro' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'personify-pro' ),
	'panel'             => 'personify_pro_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'personify-pro' ),
	'section'          	=> 'personify_pro_breadcrumb',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'personify_pro_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'personify-pro' ),
	'active_callback' 	=> 'personify_pro_is_breadcrumb_enable',
	'section'          	=> 'personify_pro_breadcrumb',
) );
