<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Footer Section
$wp_customize->add_section( 'personify_pro_section_footer',
	array(
		'title'      		=> esc_html__( 'Footer Options', 'personify-pro' ),
		'priority'   		=> 900,
		'panel'      		=> 'personify_pro_theme_options_panel',
	)
);

// footer name enable
$wp_customize->add_setting( 'personify_pro_theme_options[footer_detail_enable]',
	array(
		'default'       	=> $options['footer_detail_enable'],
		'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[footer_detail_enable]',
    array(
		'label'      		=> esc_html__( 'Enable Footer Detail Section', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'on_off_label' 		=> personify_pro_enable_options(),
    )
) );

// footer name enable
$wp_customize->add_setting( 'personify_pro_theme_options[footer_name_enable]',
	array(
		'default'       	=> $options['footer_name_enable'],
		'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[footer_name_enable]',
    array(
		'label'      		=> esc_html__( 'Show Footer Name', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'active_callback'   => 'personify_pro_is_footer_detail_enable',
		'on_off_label' 		=> array(
			'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
			'off' 		=> esc_html__( 'No', 'personify-pro' )
		)
    )
) );

// footer first name
$wp_customize->add_setting( 'personify_pro_theme_options[footer_firstname]',
	array(
		'default'       	=> $options['footer_firstname'],
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport'			=> 'postMessage',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[footer_firstname]',
    array(
		'label'      		=> esc_html__( 'First Name', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'type'		 		=> 'text',
		'active_callback'	=> 'personify_pro_is_footer_name_enable',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[footer_firstname]', array(
		'selector'            => '.footer-widgets-area .wrapper section#text .first-name',
		'settings'            => 'personify_pro_theme_options[footer_firstname]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_footer_firstname_partial',
    ) );
}

// footer last name
$wp_customize->add_setting( 'personify_pro_theme_options[footer_lastname]',
	array(
		'default'       	=> $options['footer_lastname'],
		'sanitize_callback'	=> 'sanitize_text_field',
		'transport'			=> 'postMessage',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[footer_lastname]',
    array(
		'label'      		=> esc_html__( 'Last Name', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'type'		 		=> 'text',
		'active_callback'	=> 'personify_pro_is_footer_name_enable',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'personify_pro_theme_options[footer_lastname]', array(
		'selector'            => '.footer-widgets-area .wrapper section#text .last-name',
		'settings'            => 'personify_pro_theme_options[footer_lastname]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'personify_pro_footer_lastname_partial',
    ) );
}

// footer menu enable
$wp_customize->add_setting( 'personify_pro_theme_options[footer_menu_enable]',
	array(
		'default'       	=> $options['footer_menu_enable'],
		'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[footer_menu_enable]',
    array(
		'label'      		=> esc_html__( 'Show Footer Menu', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'active_callback'   => 'personify_pro_is_footer_detail_enable',
		'on_off_label' 		=> array(
			'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
			'off' 		=> esc_html__( 'No', 'personify-pro' )
		)
    )
) );

// footer social menu enable
$wp_customize->add_setting( 'personify_pro_theme_options[footer_social_menu_enable]',
	array(
		'default'       	=> $options['footer_social_menu_enable'],
		'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[footer_social_menu_enable]',
    array(
		'label'      		=> esc_html__( 'Show Social Menu', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'active_callback'   => 'personify_pro_is_footer_detail_enable',
		'on_off_label' 		=> array(
			'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
			'off' 		=> esc_html__( 'No', 'personify-pro' )
		)
    )
) );

// footer text
$wp_customize->add_setting( 'personify_pro_theme_options[copyright_text]',
	array(
		'default'       	=> $options['copyright_text'],
		'sanitize_callback'	=> 'personify_pro_santize_allow_tag',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[copyright_text]',
    array(
		'label'      		=> esc_html__( 'Copyright Text', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'type'		 		=> 'textarea',
    )
);

// footer text
$wp_customize->add_setting( 'personify_pro_theme_options[powered_by_text]',
	array(
		'default'       	=> $options['powered_by_text'],
		'sanitize_callback'	=> 'personify_pro_santize_allow_tag',
	)
);
$wp_customize->add_control( 'personify_pro_theme_options[powered_by_text]',
    array(
		'label'      		=> esc_html__( 'Powered By Text', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'type'		 		=> 'textarea',
    )
);

// scroll top visible
$wp_customize->add_setting( 'personify_pro_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[scroll_top_visible]',
    array(
		'label'      		=> esc_html__( 'Display Scroll Top Button', 'personify-pro' ),
		'section'    		=> 'personify_pro_section_footer',
		'on_off_label' 		=> array(
			'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
			'off' 		=> esc_html__( 'No', 'personify-pro' )
		)
    )
) );