<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

// Add layout section
$wp_customize->add_section( 'personify_pro_layout', array(
	'title'               => esc_html__('Layout','personify-pro'),
	'description'         => esc_html__( 'Layout section options.', 'personify-pro' ),
	'panel'               => 'personify_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[site_layout]', array(
	'sanitize_callback'   => 'personify_pro_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new Personify_Pro_Custom_Radio_Image_Control ( $wp_customize, 'personify_pro_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'personify-pro' ),
	'section'             => 'personify_pro_layout',
	'choices'			  => personify_pro_site_layout(),
) ) );

// Title Break setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[title_break]', array(
	'default'           => $options['title_break'],
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[title_break]', array(
	'label'             => esc_html__( 'Break Title', 'personify-pro' ),
	'description'       => esc_html__( 'First word is highlighted in all inner pages.', 'personify-pro' ),
	'section'           => 'personify_pro_layout',
	'on_off_label' 		=> array(
		'on' 		=> esc_html__( 'Yes', 'personify-pro' ),
		'off' 		=> esc_html__( 'No', 'personify-pro' )
	)
) ) );