<?php
/**
 * Loader options
 *
 * @package Theme Palace
 * @subpackage Personify Pro
 * @since Personify Pro 1.0
 */

$wp_customize->add_section( 'personify_pro_loader', array(
	'title'            		=> esc_html__( 'Loader','personify-pro' ),
	'description'      		=> esc_html__( 'Loader section options.', 'personify-pro' ),
	'panel'            		=> 'personify_pro_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[loader_enable]', array(
	'sanitize_callback' => 'personify_pro_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new Personify_Pro_Switch_Control( $wp_customize, 'personify_pro_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'personify-pro' ),
	'section'             	=> 'personify_pro_loader',
	'on_off_label' 		=> personify_pro_enable_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'personify_pro_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'personify_pro_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'personify_pro_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'personify-pro' ),
	'section'         		=> 'personify_pro_loader',
	'type'					=> 'select',
	'choices'				=> personify_pro_get_spinner_list(),
	'active_callback' 		=> 'personify_pro_is_loader_enable',
) );
